/**
 * Documentazione
 * http://arshaw.com/fullcalendar/docs/
 */
var enable_debug = true;


(function($) {
	/* Tabs
	-------------------------------------------------------------- */
	$.fn.popuptabs = function() {
		return this.each(function() {
			var
				element = $(this),
				tabs = element.find('ul.tabsNav li a'),
				panels = element.find('.tabsPanel');

			tabs.click(function(event) {
				var tab = $(this),
					selector = tab.attr('href');

				if (/^http(s?):\/\//.test(selector)) {
					return;
				}

				event.preventDefault();

				panels.removeClass('active');
				panels.filter( selector ).addClass('active');

				tabs.closest('li').removeClass('active');
				tab.closest('li').addClass('active');
			});
		});
	}; // END Tabs
})(jQuery);

(function($) {
	function debug (value) {
		if (enable_debug) {
			console.log(value);
		}
	}

	/**
	 * Variabili globali
	 */
	var closeTrigger,
		categories = {},
		category;

	/**
	 * Callback di default
	 */
	function dropCallback(date, allDay, jsEvent, ui, event, cal, popup) {
debug('dropCallback');
		var e = $(event).data('eventObject'),
			split;

		// Imposto le ore di inizio e fine predefinite per l'evento draggato
		split = e.startTime.split(':');
		e.start = new XDate(date).setHours(split[0]).setMinutes(split[1]).toDate();

		split = e.endTime.split(':');
		e.end = new XDate(date).setHours(split[0]).setMinutes(split[1]).toDate();

		// Apro il colorbox per consentire di rifinire i dettagli (es se si vuole impostare un titolo diverso o una descrizione)
		e.pongho_action = 'add';
		openCBox(popup, e, cal);
	}

	function eventClickCallback(calEvent, jsEvent, view) {
debug('eventClickCallback');
		calEvent.pongho_action = 'edit';
		openCBox(calEvent, view.calendar);
	}

	function eventDoubleClickCallback(calEvent, jsEvent, view) {
debug('eventDoubleClickCallback');
		calEvent.pongho_action = 'edit';
		openCBox(calEvent, view.calendar);
	}

	function eventDropCallback(calEvent, dayDelta, minuteDelta, allDay, revertFunc, jsEvent, ui, view, url) {
debug('eventDropCallback');
		calEvent.pongho_action = 'edit';
		var data = {
			'action': 'move',
			'calendar_id': (typeof calEvent.resourceId != 'undefined' ? calEvent.resourceId : calEvent.calendar),
			'category_id': (typeof calEvent.resourceId != 'undefined' && calEvent.resourceId === calEvent.calendar ? calEvent.category : undefined),
			'title': calEvent.title,
			'content': calEvent.description,
			'start_date_at': new XDate(calEvent.start).toString('yyyy-MM-dd HH:mm'),
			'end_date_at': new XDate(calEvent.end).toString('yyyy-MM-dd HH:mm'),
			'is_all_day': calEvent.allDay ? 1 : 0,
			'status': calEvent.status
		};
		editEvent(view.calendar, calEvent, data, url);
	}

	function eventRenderCallback(calEvent, element) {
		element.find('.fc-event-content').append('<span>' + calEvent.description + '</span>');
	}

	function eventResizeCallback(calEvent, dayDelta, minuteDelta, revertFunc, jsEvent, ui, view, url) {
debug('eventResizeCallback');
		calEvent.pongho_action = 'edit';
		var data = {
			'action': calEvent.pongho_action,
			'calendar_id': calEvent.calendar,
			'category_id': calEvent.category,
			'title': calEvent.title,
			'content': calEvent.description,
			'start_date_at': new XDate(calEvent.start).toString('yyyy-MM-dd HH:mm'),
			'end_date_at': new XDate(calEvent.end).toString('yyyy-MM-dd HH:mm'),
			'is_all_day': calEvent.allDay ? 1 : 0,
			'status': calEvent.status
		};
		editEvent(view.calendar, calEvent, data, url);
	}

	function eventResizeStartCallback(event, jsEvent, ui, view) {
debug('eventResizeStartCallback');
	}

	function eventResizeStopCallback(event, jsEvent, ui, view) {
debug('eventResizeStopCallback');
	}

	function selectCallback(startDate, endDate, allDay, jsEvent, resourceId, view) {
debug('selectCallback');
		openCBox({
			'title': '',
			'start': startDate,
			'calendar': resourceId,
			'end': endDate,
			'allDay': allDay,
			'pongho_action': 'add',
		}, view.calendar);

		view.calendar.unselect();
	}

	function eventCustomFieldsCallback(calEvent, popup) {}

	function eventSaveCustomFieldsCallback(calEvent, popup, data) {
		return data;
	}

	function beforeEventSaveCallback(cal, calEvent, data) {
		return data;
	}

	function afterEventSaveCallback(cal, calEvent, data) {}


	/**
	 * Callback per la maschera di modifica eventi
	 */
	function addUserRowCallback(row, calEvent, item, counter) {
		row.removeClass('clonable').addClass('user-row');
		row.find('span.name').text(item.label);
		row.find('.user-id').val(item.id);

		updateRowId(row, '[new_'+counter+']');

		calEvent.participants.push({
			'user_id': item.id,
			'label': item.label,
			'status': 'active',
			'custom_created_at': new XDate().toString('yyyy-MM-dd HH:mm')
		});

		row.find('.delete').attr('data-src', item.id);
	}

	function loadUserRowCallback(row, participant) {
debug('aggiungo partecipante');
		row.removeClass('clonable').addClass('user-row');
		row.find('span.name').text(participant.label);
		row.find('.user-id').val(participant.user_id);

		updateRowId(row, '[' + participant.user_id + ']');

		row.find('.delete').attr('data-src', participant.user_id);
	}

	/**
	 * Funzioni di supporto
	 */
	function updateRowId(row, id)
	{
		row.find('input').each(function() {
			var field = $(this),
				name = field.attr('name');

			field.attr('name', name.replace(/\[new\]/i, id));
		});
	}

	// Callback di base da sovrascrivere
	function afterPopupOpenCallback(popup, cal, calEvent) {}
	function afterPopupOpenAddCallback(popup, cal, calEvent) {}
	function afterPopupOpenEditCallback(popup, cal, calEvent) {}
	function beforePopupOpenCallback(popup, cal, calEvent) {}
	function beforePopupCloseCallback(popup, cal, calEvent) {}
	function popupCloseCustomActionCallback(cal, calEvent, p, data, url) {
		debug('Nessuna operazione disponibile per l\'azione di chiusura: ' + data.action);
	}

	function handleParticipants(popup, calEvent) {
debug('gestione partecipanti');
		var list = $("#users-list", popup),
			table = $("table", list),
			tbody = $("tbody", list),
			clonable = $(".clonable", list).hide().clone(),
			search = $("#field-user-search", popup),
			roles = search.data('filter-roles'),
			url = search.data('url'),
			counter = 0;

		// Pulisco tutte le righe che potrebbero essere rimaste dalla precedente apertura del colorbox
		//tbody.find('.user-row').remove();

		if (calEvent.participants === undefined) calEvent.participants = [];

		//$.each(calEvent.participants, function(index, participant) {
		//	clonable.clone().each(function () {
		//
		//		loadUserRowCallback($(this), participant);
		//
		//	}).appendTo(tbody).show();
		//});

		// Ricerca
		search.keydown(function (event) {
			if (event.which == 13) {
				event.preventDefault();
			}
		}).autocomplete({
			source: function (request, response) {
				request.filter_roles = roles;
				request.not_in = [];
				for ( index in calEvent.participants ) {
					if (calEvent.participants.hasOwnProperty(index)) {
						request.not_in.push(calEvent.participants[index].user_id);
					}
				}

				$.getJSON(url, request, function (data) {
					response(data);
				});
			},
			select: function (event, ui) {
				counter++;

				clonable.clone().each(function () {

					addUserRowCallback($(this), calEvent, ui.item, counter);

				}).appendTo(tbody).show();

				search.val('');

				return false;
			}
		});

		// Eliminazione
		table.on('click', '.delete', function(event) {
			var that = $(this);

			for ( index in calEvent.participants ) {
				if (calEvent.participants.hasOwnProperty(index) && calEvent.participants[index].user_id === that.data('src')) {
					if (that.data('url')) {
						data = {
							'event_id'	: calEvent.id
						};

						$.post(that.data('url'), data, function(d) {
							if (d.error) {
								alert(d.message);
							} else {
debug('participant->delete[ajax]');
								delete calEvent.participants[index];
								that.closest('.user-row').fadeOut(function () {
									$(this).remove();
								});
							}
						});
					} else {
debug('participant->delete[js]');
						delete calEvent.participants[index];
						that.closest('.user-row').fadeOut(function () {
							$(this).remove();
						});
					}
					break;
				}
			}

		});
	}

	//function setCalendar(popup, category) {
	//	var select = popup.find('[name="calendar"]'),
	//		calendar_id = select.find('option:selected').val() || select.val() || 0,
	//		calendar_key = 'calendar_' + calendar_id,
	//		categoryField = $('[name="category"]', popup);
	//
	//	if (calendar_key in categories) {
	//		categoryField.html(categories[calendar_key]).val(category);
	//	} else {
	//		$.post(popup._categories_url, {'calendar_id': calendar_id}, function(d) {
	//			if (d.error) {
	//				alert(d.message);
	//			} else {
	//				categories[calendar_key] = d;
	//				categoryField.html(d).val(category);
	//			}
	//		}, 'json');
	//	}
	//}

	function editEvent(cal, calEvent, data, url) {
debug('editEvent');
		if (data.title !== '') {
			data.id = calEvent.id;

			// data.participants = [];
			// for ( index in calEvent.participants ) {
			// 	if (calEvent.participants.hasOwnProperty(index)) {
			// 		var obj = calEvent.participants[index];
			// 		data.participants.push(obj);
			// 	}
			// }

debug('beforeEventSaveCallback');
			data = cal.options.beforeEventSave(cal, calEvent, data);
console.log(url);
			$.post(url, data, function(d) {
				if (d.error) {
					alert(d.message);
				} else {
					calEvent.author = d.author_id;
					calEvent.calendar = d.calendar_id;
					calEvent.category = d.category_id;
					calEvent.title = d.title;
					calEvent.description = d.content;
					calEvent.start = d.start_date_at;
					calEvent.end = d.end_date_at;
					calEvent.allDay = d.is_all_day;
					calEvent.status = d.status;
					calEvent.textColor = d.text_color;
					calEvent.color = d.bg_color;
					calEvent.participants = d.participants;
					calEvent.resourceId = d.calendar_id;

					if (data.action === 'add') {
						calEvent.id = d.id;

						if (cal.options.disableRefetch) {
							cal.renderEvent(calEvent);
						}
					} else if (data.action === 'edit') {
						cal.updateEvent(calEvent);
					} else {
						cal.removeEvents(calEvent.id);
					}

debug('afterEventSaveCallback');
					cal.options.afterEventSave(cal, calEvent, data);
				}

				if (!cal.options.disableRefetch) {
debug('refetch');
					cal.refetchEvents();
				}
			});
		}

	}

	function openCBox(calEvent, cal) {
debug('apro il popup');
		var p, actions, url;

		$.colorbox({
			'href'				: cal.options.popup_selector,
			'innerHeight'		: 600,
			'innerWidth'		: 800,
			'data'		: {
				'action'		: calEvent.id ? calEvent.pongho_action : 'add',
				'handler'		: cal.options.handler,
				'event_id'		: calEvent.id,
				'resource_id'	: calEvent.calendar,
				'start'			: new XDate(calEvent.start).toString('yyyy-MM-dd HH:mm'),
				'end'			: new XDate(calEvent.end).toString('yyyy-MM-dd HH:mm'),
				'is_all_day'	: calEvent.full_day || 0
			},
			'onComplete': function () {
debug('inizializzazione del popup');
				closeTrigger = 'cancel';
				p = $('#calendar-popup');
				url = $('form', p).attr('action');
				p.popuptabs();

				$('.datepicker').datepicker();
				$('.timepicker').timepicker();
				$('.datetimepicker').datetimepicker();

				p._actions = p.find('#calendar-popup-actions');

				// Bottoni delle azioni
				p._actions.on('click', 'input[type="button"]', function (e) {
					closeTrigger = $(this).data('action');
					$.colorbox.close();
					e.preventDefault();
				});

debug('autocomplete aggiunta utenti');
				// Autocomplete aggiunta utenti
				handleParticipants(p, calEvent);

				// Gestisce il caricamento delle nuove categorie se ho la select per cambiare il calendario
				//setCalendar(p, calEvent.category);

debug('action: '+calEvent.pongho_action);
				if (calEvent.pongho_action === 'add') {
					// nuovo evento
					p.find('input, select, textarea').each(function () {
						var field = $(this);

						if (!field.is('[type="button"]')) {
							handleFieldType(field, p.data('default-' + field.attr('name')));
						}
					});

debug('trigger della callback afterPopupOpenAddCallback');
					cal.options.afterPopupOpenAddCallback(p, cal, calEvent);
				} else {
					// modifica evento
					//cal.options.eventCustomFields(calEvent, p);

debug('trigger della callback afterPopupOpenEditCallback');
					cal.options.afterPopupOpenEditCallback(p, cal, calEvent);
				}
			},
			'onClosed'	: function() {
debug('trigger della callback beforePopupCloseCallback');
				cal.options.beforePopupCloseCallback(p, cal, calEvent);

debug('compilo l\'oggetto data');
				var data = {};
				p.find('input, select, textarea').each(function () {
					var field = $(this);
					if (!field.is('[type="button"]')) {
						data[field.data('col') || field.attr('name')] = handleFieldType(field);
					}
				});

				data.action = closeTrigger;

debug('filtro l\'oggetto data per modificare eventuali custom fields');
				data = cal.options.eventSaveCustomFields(calEvent, p, data);

				switch (closeTrigger){
					case 'delete':
debug('cancello l\'evento');
						if (calEvent.id !== undefined){
							editEvent(cal, calEvent, data, url);
						}
						break;

					case 'edit':
debug('salvo l\'evento');
						editEvent(cal, calEvent, data, url);

						break;

					case 'cancel':
debug('annullo l\'azione');
						break;

					default:
debug('azione custom: ' + closeTrigger);
						cal.options.popupCloseCustomActionCallback(cal, calEvent, p, data, url);

						editEvent(cal, calEvent, data, url);
						break;
				}
			}
		});
	}

	/**
	 * Funzione per gestire i campi particolari, ad esempio le checkbox
	 * Se viene passato un valore, questo viene impostato nel campo, altrimenti viene restituito il valore del campo
	 */
	function handleFieldType(field, value)
	{
		if (field === undefined) return false;

		if (field.is('[type="checkbox"]')) {
			if ( value !== undefined) {
				field.attr('checked', value);
			} else {
				return field.is(':checked');
			}
		} else {
			if ( value !== undefined) {
				// Se il campo è una data, consento di sovrascrivere l'ora
				if (field.hasClass('input_datetime')) {
					if (field.data('hours') !== undefined) {
						var split = field.data('hours').split(':');
						value = new XDate(value).setHours(split[0]).setMinutes(split[1]).toDate();

						field.val(new XDate(value).toString('yyyy-MM-dd HH:mm'));
					}
				} else {
					// Altrimenti è un campo normale e ci inserisco il valore
					field.val(value);
				}
			} else {
				return field.val();
			}
		}

		return true;
	}

	$.fn.ponghoFullCalendar = function(options) {
		var o = $.extend({}, $.fn.ponghoFullCalendar.defaults, options),
			cal = $(this), popup,
			counter = 1,
			loading;

		if ($.colorbox === undefined) {
			throw 'Colorbox plugin is required!';
		}

		if (o.popup_selector === undefined) {
			throw 'Option "popup_selector" must be defined!';
		}

		popup = {
			_participants_load_callback	: o.loadUserRowCallback,
			_participants_add_callback	: o.addUserRowCallback
		};

		// Gestione ratio di ridimensionamento del calendario
		$(window).resize(function (event) {
			if (o.aspect_ratio_handling === 'auto') {
				var widthOffset = 216, // Larghezza della sidebar di Pongho + margine destro
					heightOffset = 138, // Altezza del titolo di Pongho e titolo del modulo + tool del calendario
					ratio = (window.innerWidth - widthOffset) / ( window.innerHeight - heightOffset);
				cal.fullCalendar('option', 'aspectRatio', ratio);
			}
		}).trigger('resize');

		/**
		 * Indicatore di caricamento per il fetching degli eventi
		 */
		loading = $('<div class="fc-loading">Caricamento in corso</div>');
		cal.append(loading);

		cal.options = o;

		/**
		 * Lego i metodi di callback sovrascrivibili alle callback del calendario aggiungendo i dati
		 * del calendario corrente che potrei non avere (es "drop" o il popup)
		 */
		o.drop = function(date, allDay, jsEvent, ui) {
			o.dropCallback(date, allDay, jsEvent, ui, this, cal.fullCalendar('getView').calendar);
		}

		o.eventClick = function(calEvent, jsEvent, view) {
			o.eventClickCallback(calEvent, jsEvent, view);
		}

		o.eventDoubleClick = function(calEvent, jsEvent, view) {
			o.eventDoubleClickCallback(calEvent, jsEvent, view);
		}

		o.eventDrop = function(calEvent, dayDelta, minuteDelta, allDay, revertFunc, jsEvent, ui, view) {
			o.eventDropCallback(calEvent, dayDelta, minuteDelta, allDay, revertFunc, jsEvent, ui, view, o.event_save_url);
		}

		o.eventRender = function(calEvent, element) {
			o.eventRenderCallback(calEvent, element);
		}

		o.eventResize = function(calEvent, dayDelta, minuteDelta, revertFunc, jsEvent, ui, view) {
			o.eventResizeCallback(calEvent, dayDelta, minuteDelta, revertFunc, jsEvent, ui, view, o.event_save_url);
		}

		o.eventResizeStart = function(event, jsEvent, ui, view) {
			o.eventResizeStartCallback(event, jsEvent, ui, view);
		}

		o.eventResizeStop = function(event, jsEvent, ui, view) {
			o.eventResizeStopCallback(event, jsEvent, ui, view);
		}

		o.select = function(startDate, endDate, allDay, jsEvent, resourceId, view) {
			o.selectCallback(startDate, endDate, allDay, jsEvent, resourceId, view);
		}

		o.popupCloseCustomAction = function(cal, calEvent, p, data, url) {
			o.popupCloseCustomActionCallback(cal, calEvent, p, data, url);
		}

		o.eventCustomFields = function(calEvent, popup) {
			o.eventCustomFieldsCallback(calEvent, popup);
		}

		o.eventSaveCustomFields = function(calEvent, popup, data) {
			return o.eventSaveCustomFieldsCallback(calEvent, popup, data);
		}

		o.beforeEventSave = function(cal, calEvent, data) {
			return o.beforeEventSaveCallback(cal, calEvent, data);
		}

		o.afterEventSave = function(cal, calEvent, data) {
			return o.afterEventSaveCallback(cal, calEvent, data);
		}

		return cal.fullCalendar(o);
	};

	$.fn.ponghoFullCalendar.defaults = {
		'aspect_ratio_handling': 'auto',
		'editable': true,
		'popup_selector': undefined,
		'popup_action_url': '',
		'popup_categories_url': '',
		'selectable': true,
		'selectHelper': true,
		'dropCallback': dropCallback,
		'eventClickCallback': eventClickCallback,
		'eventDoubleClickCallback': eventDoubleClickCallback,
		'eventDropCallback': eventDropCallback,
		'eventRenderCallback': eventRenderCallback,
		'eventResizeCallback': eventResizeCallback,
		'eventResizeStartCallback': eventResizeStartCallback,
		'eventResizeStopCallback': eventResizeStopCallback,
		'selectCallback': selectCallback,
		'loadUserRowCallback': loadUserRowCallback,
		'addUserRowCallback': addUserRowCallback,
		'eventCustomFieldsCallback': eventCustomFieldsCallback,
		'eventSaveCustomFieldsCallback': eventSaveCustomFieldsCallback,
		'beforeEventSaveCallback': beforeEventSaveCallback,
		'afterEventSaveCallback': afterEventSaveCallback,
		'loading': function(isLoading, view) {
			if (isLoading) {
				$('.fc-loading').show();
			} else {
				$('.fc-loading').hide();
			}
		},

		//popup
		'afterPopupOpenCallback': afterPopupOpenCallback,
		'afterPopupOpenAddCallback': afterPopupOpenAddCallback,
		'afterPopupOpenEditCallback': afterPopupOpenEditCallback,
		'beforePopupOpenCallback': beforePopupOpenCallback,
		'beforePopupCloseCallback': beforePopupCloseCallback,
		'popupCloseCustomActionCallback': popupCloseCustomActionCallback,

		// Localization
		'buttonText': {
			prev:     '&nbsp;&#9668;&nbsp;',  // left triangle
			next:     '&nbsp;&#9658;&nbsp;',  // right triangle
			prevYear: '&nbsp;&lt;&lt;&nbsp;', // <<
			nextYear: '&nbsp;&gt;&gt;&nbsp;', // >>
			today:    'Oggi',
			month:    'Mese',
			week:     'Settimana',
			day:      'Giorno',
			resourceDay: 'Risorse'
		},
		'columnFormat': {
			month: 'ddd',    // Mon
			week: 'ddd d/M', // Mon 9/7
			day: 'dddd d/M'  // Monday 9/7
		},
		'dayNames': ['Domenica', 'Lunedì', 'Martedì', 'Mercoledì','Giovedì', 'Venerdì', 'Sabato'],
		'dayNamesShort': ["Dom", "Lun", "Mar", "Mer", "Gio", "Ven", "Sab", "Dom"],
		'monthNames': ["Gennaio", "Febbraio", "Marzo", "Aprile", "Maggio", "Giugno","Luglio", "Agosto", "Settembre", "Ottobre", "Novembre", "Dicembre"],
		'monthNamesShort': ["GEN", "FEB", "MAR", "APR", "MAG", "GIU", "LUG", "AGO","SET", "OTT", "NOV", "DIC"],
		'timeFormat': 'HH:mm',
		'titleFormat': {
			//'month': 'MMMM yyyy',
			//'week': "MMM d[ yyyy]{ '&#8212;'[ MMM] d yyyy}",
			'day': 'dddd, d MMMM yyyy'
		}
	};
})(jQuery);
