<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\Model;

use ActiveRecord\Base;

class CalendarUser extends Base
{
    /**
     * Tabella
     */
    public static $table_name = 'calendars_users';

    public static $primary_key = array('calendar_id', 'user_id');

    public static $belongs_to = array(
        array('user', 'model' => 'Application\\Core\\Model\\Account'),
    );

    public static function findByCalendarAndUser($calendar_id, $user_id)
    {
        $options = array(
            'conditions' => array(
                'calendar_id = :calendar AND user_id = :user',
                'calendar' => $calendar_id,
                'user'     => $user_id
            ),
        );

        return self::first($options);
    }
}
