<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\Model;

use ActiveRecord\Base;
use Application\Core\Model\Account;
use Pongho\Utilities\DateTime;

/**
 * CalendarEventUser
 *
 * @property int      $calendar_event_id
 * @property int      $user_id
 * @property string   $status
 * @property DateTime $created_at
 * @property Account  $user
 */
class CalendarEventUser extends Base
{
    /**
     * Tabella
     */
    public static $table_name = 'calendars_events_users';

    public static $primary_key = array('calendar_event_id', 'user_id');

    public static $belongs_to = array(
        array('user', 'model' => Account::class),
    );

    public static function findByEventAndUser($event_id, $user_id)
    {
        $options = array(
            'conditions' => array(
                'calendar_event_id = :event AND user_id = :user',
                'event' => $event_id,
                'user'  => $user_id
            ),
        );

        return self::first($options);
    }
}
