<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\Model;

use ActiveRecord\Base;

/**
 * CalendarCategory
 *
 * @property int    $id
 * @property int    $calendar_id
 * @property string $title
 *
 * @method static CalendarCategory[] all(array $options)
 * @method static CalendarCategory find(int $id)
 */
class CalendarCategory extends Base
{
    /**
     * Tabella
     */
    public static $table_name = 'calendars_categories';

    /**
     * @inherits
     */
    public function delete()
    {
        return $this->updateCalendarEventsCategory()
            && parent::delete();
    }

    /**
     * @return bool
     */
    public function deleteEvents()
    {
        foreach ($this->getEvents() as $event) {
            if (!$event->delete()) {
                return false;
            }
        }

        return true;
    }

    /**
     * @return CalendarEvent[]
     */
    public function getEvents()
    {
        return CalendarEvent::all([
            'conditions' => [
                'category_id = :category',
                'category' => $this->id,
            ],
        ]);
    }

    /**
     * @return bool
     */
    private function updateCalendarEventsCategory()
    {
        foreach ($this->getEvents() as $event) {
            $event->category_id = null;

            if (!$event->save()) {
                return false;
            }
        }

        return true;
    }
}
