<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar;

use Application\Admin\AdminSidebar\Sidebar;
use Application\Calendar\Controller\Admin\CalendarController as AdminCalendarController;
use Application\Calendar\Controller\Admin\CalendarOptionsController as AdminCalendarOptionsController;
use Application\Calendar\Controller\CalendarController;
use Application\Core\Model\Module;
use Pongho\Core\Plugin;
use Pongho\DependencyInjection\Container;
use Pongho\EventDispatcher\Event;

/**
 * Kernel
 */
class Kernel extends Plugin
{
    const VERSION = '1.0.8';
    const FRONT_CONTROLLER = CalendarController::class;

    /**
     * {@inheritdoc}
     */
    public function setUp()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function load()
    {
        $this->connect('admin.translations.filter_partitions', 'filterTranslationsPartitions');

        $this->container->extend('admin_sidebar', function (Sidebar $sidebar, Container $container) {
            /** @var \Application\Core\I18n\Translation\Translator $translator */
            $translator = $container->get('translator');

            /** @var \Application\Core\User $user */
            $user = $container->get('current_user');

            if ($user->hasPermit('calendar.admin')) {
                $sidebar->addPanel('Calendari', 'calendars', 'calendar', Sidebar::POS_APPS);

                if ($module = $this->getCalendarModule()) {
//					$sidebar->addItem(
//						'Calendario',
//						'/calendar/view/',
//						'calendars',
//						Sidebar::POS_PANEL_ACTIONS,
//						'Application\\Calendar\\Controller\\Admin\\CalendarController',
//						$module->id
//					);

                    $sidebar->addItem(
                        $translator->trans('List'),
                        '/calendar/',
                        'calendars',
                        Sidebar::POS_PANEL_ACTIONS,
                        AdminCalendarController::class,
                        $module->id
                    );

                    // TODO: valutare permesso per aggiunta calendari
                    $sidebar->addItem(
                        $translator->trans('Add'),
                        '/calendar/add/',
                        'calendars',
                        Sidebar::POS_PANEL_ACTIONS,
                        AdminCalendarController::class,
                        $module->id
                    );

                    if ($user->isFounder()) {
                        $sidebar->addItem(
                            $translator->trans('Options'),
                            '/calendar-options/',
                            'calendars',
                            Sidebar::POS_PANEL_SETTINGS,
                            AdminCalendarOptionsController::class,
                            $module->id
                        );
                    }
                } else {
                    echo '<p class="alert error">L’applicazione Calendar non è correttamente configurata, sembra mancare il modulo<p>';
                }
            }
        });
    }

    /**
     * @param Event $event
     * @param array $partitions
     * @return array
     */
    public function filterTranslationsPartitions(Event $event, array $partitions)
    {
        $partitions[] = 'calendar';

        return $partitions;
    }

    /**
     * @return Module
     *
     * @todo Manager
     */
    protected function getCalendarModule()
    {
        $options = [
            'conditions' => [
                'controller = ?',
                Kernel::FRONT_CONTROLLER
            ],
            'cachable'   => true,
        ];

        return Module::first($options);
    }
}
