<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\Handler\View;

use Application\Calendar\Handler\ViewInterface;

class Single extends Base implements ViewInterface
{
    public function getView()
    {
        $path = $this->site_module->path;
        $calendars = $this->data_handler->getCalendars();

        $calendar_ids = array();
        foreach ($calendars as $calendar) {
            $calendar_ids[] = $calendar->id;
        }

        $events = array(
            'url'  => url("{$path}getevents/"),
            'data' => array(
                'calendars' => $calendar_ids,
                'handler'   => $this->data_handler->getClassPath(),
            ),
            'type' => 'POST',
        );
        $calendar_options['events'] = $events;

        $json = json_encode(array_merge(array(
            'handler' => $this->data_handler->getClassPath(),
            'events'  => $events,
        ), $this->calendar_options));

        $code = "\$(document).ready(function() {\$('$this->calendar_container').ponghoFullCalendar($json);});";

        $this->populateHead($code);
    }

    public static function getClassPath()
    {
        return 'Application\\Calendar\\Handler\\View\\Single';
    }
}
