<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\Handler\View;

use Application\Calendar\Handler\Data\Base as DataHandler;
use Application\Core\User;
use Pongho\Template\HeadHelper;
use Pongho\Template\ViewInterface;

abstract class Base
{
    /** @var \Pongho\Template\HeadHelper */
    protected $view;

    /** @var \Pongho\Template\ViewInterface */
    protected $head;

    protected $site_module;

    protected $calendar_container;

    protected $calendar_options;

    protected $user;

    protected $data_handler;

    /**
     * Costruttore
     *
     * @access public
     *
     * @param \Pongho\Template\ViewInterface $view               Vista del template engine
     * @param \Pongho\Template\HeadHelper    $head               Head del template engine
     * @param int                            $site_module        module_site dell'applicazione corrente, da cui ricavare i percorsi e le opzioni
     * @param string                         $calendar_container selettore del tag che contiene il calendario
     * @param array                          $calendar_options   Array con le impostazioni personalizzate del calendario
     * @param DataHandler                    $data_handler       Handler di gestione dei dati di questa vista (può essere una classe che eredita da Calendar\Handler\Data\Base)
     * @param \Application\Core\User         $user               l'utente corrente che sta utilizzando la vista
     */
    public function __construct(
        ViewInterface $view,
        HeadHelper $head,
        $site_module,
        $calendar_container,
        $calendar_options,
        DataHandler $data_handler,
        User $user
    ) {
        $this->view = $view;
        $this->head = $head;
        $this->site_module = $site_module;
        $this->calendar_container = $calendar_container;
        $this->calendar_options = $calendar_options;
        $this->user = $user;
        $this->data_handler = $data_handler;
    }

    /**
     * @param string $code
     */
    protected function populateHead($code)
    {
        $this->head
            ->addCss(pongho_url('/vendor/jQuery-plugins/FullCalendar/fullcalendar.css'))
            ->addJavaScript(pongho_url('/vendor/XDate/xdate.js'))
            ->addJavaScript(pongho_url('/vendor/jQuery-plugins/FullCalendar/fullcalendar.min.js'))
            ->addJavaScript(
                pongho_url(
                    '/Application/Calendar/Resources/public/js/jquery.calendar.js?v=' . filemtime(__DIR__ . '/../../Resources/public/js/jquery.calendar.js')
                )
            )
            ->addJavaScriptInline($code);
    }
}
