<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\Controller\Admin;

use Application\Admin\Controller\ModuleOptionsController;

class CalendarOptionsController extends ModuleOptionsController
{
    /**
     *
     */
    public function indexAction()
    {
        $modulesite = $this->getSiteModuleClassName();
        $calendar_views = $modulesite::getCalendarViews();

        $options = array(
            'default_calendar_admin_view' => 'string',
            'min_calendar_day_time'       => 'string',
            'max_calendar_day_time'       => 'string',
            'first_day'                   => 'integer',
        );

        $this->handleRequest($options);

        $this->getBodyView()
            ->setTemplatePath(__DIR__ . '/../../Resources/views/calendar_options.php')
            ->assignVars(array(
                'action_form'                  => $this->url('/' . $this->getParameter('path') . '/'),
                'default_calendar_admin_views' => $calendar_views,
            ));
    }

    /**
     * @inherits
     */
    protected function getSiteModuleClassName()
    {
        return 'Application\\Calendar\\Model\\ModuleSite';
    }
}
