<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Calendar
 */

namespace Application\Calendar\Controller\Admin;

use Application\Admin\Controller\CrudController;
use Pongho\Core\TemplateResponse;
use Application\Calendar\Controller\AjaxController as CalendarAjaxController;
use Pongho\Http\Exception\HttpNotFoundException;

/**
 * Classe per estendere il CrudController con le azioni del calendario (dependency injection)
 */
abstract class AjaxController extends CrudController
{
    public function __call($method, array $arguments)
    {
        if (method_exists('Application\\Calendar\\Controller\\AjaxController', $method)) {
            $controller = new CalendarAjaxController($this->getRequest());

            $controller->setParameters($this->getContainer()->getParameters());
            $controller->setContainer($this->getContainer());

            return $controller->$method();
        }

        //throw new HttpNotFoundException();

        return parent::__call($method, $arguments);
    }

    /**
     *
     */
    public function getpopupAction()
    {
        if (!isset($_POST['handler'])) {
            throw new HttpNotFoundException('Handler del calendario non impostato');
        }

        $post = $_POST;

        $handler = $post['handler'];

        //$post['event'] = $this->parsePost($post['event']);
        try {
            $post = $handler::parseFields($post);
        } catch (\Exception $e) {
            return $this->getHelper()->displayError($e->getMessage());
        }

        $handler::getPopupTemplate($post, $this->getContainer());

        return new TemplateResponse($this->getHelper()->getBodyView());
    }
}
