<?php

use Application\Calendar\Model\CalendarEvent;

/**
 * Restituisce un array con le lezioni di guida compresse (vengono compresse due guide consecutive che partono
 * dallo stesso luogo e la seconda inizia alla fine della prima)
 *
 * @access public
 * @param array $options Le opzioni per filtrare l'evento del calendario
 * @return array
 */
function getDrivingLessonsCompressed(array $options)
{
    $lessons = [];
    $i = 1;
    foreach (CalendarEvent::all($options) as $lesson) {
        $key = $lesson->start_date_at->format('Ymd') . '_' . $lesson->calendar_id . '_' . $lesson->custom_start_place;

        if (!array_key_exists("{$key}_{$i}", $lessons)) {
            $i = 1;
            $lessons["{$key}_{$i}"] = new CalendarEvent($lesson->attributes);
        } else {
            if ($lessons["{$key}_{$i}"]->start_date_at == $lesson->end_date_at) {
                $lessons["{$key}_{$i}"]->start_date_at = $lesson->start_date_at;
            } else {
                $i++;
                $lessons["{$key}_{$i}"] = new CalendarEvent($lesson->attributes);
            }
        }
    }

    return $lessons;
}

/**
 * Trasforma le ore in minuti
 */
function hours2minutes($time)
{
    $timesplit = explode(':', $time);

    return intval($timesplit[0], 10) * 60 + intval($timesplit[1], 10);
}
