<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Autoscuola
 */

namespace Application\Autoscuola\Model;

use ActiveRecord\Base;

/**
 * StudentComment
 *
 * @property int                             $id
 * @property int                             $student_id
 * @property int                             $author_id
 * @property string                          $content
 * @property \Pongho\Utilities\DateTime      $created_at
 * @property \Application\Core\Model\Account $author
 */
class StudentComment extends Base
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'autoscuola_students_comments';

    /**
     * Relazione `belongs_to`.
     *
     * @var array
     */
    public static $belongs_to = [
        ['author', 'model' => \Application\Core\Model\Account::class],
    ];
}
