<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Autoscuola
 */

namespace Application\Autoscuola\Model;

use Application\Core\Model\ModuleSite as Base;

/**
 * ModuleSite
 */
class ModuleSite extends Base
{
    /**
     * Insegnante teoria
     */
    public const ROLE_TEACHER_T = 4;

    /**
     * Studente teoria
     */
    public const ROLE_STUDENT_T = 5;

    /**
     * Istruttore pratica
     */
    public const ROLE_TEACHER_P = 6;

    /**
     * Allievo pratica
     */
    public const ROLE_STUDENT_P = 7;

    /**
     * Insegnante/Istruttore
     */
    public const ROLE_TEACHER = 8;

    /**
     * Ruolo amministrativo (per la segreteria, senza accesso a pongho)
     */
    public const ROLE_ADMIN = 9;

    public const CALENDAR_TEORIA = 5;

    public const CALENDAR_PRATICA = 6;

    public const CALENDAR_SITE_MODULE = 32;

    public const EXAMINER_SITE_MODULE = 35;

    /**
     * @var array
     */
    public static $colors = [
        'free'        => ['bg' => '#E3E3E3', 'text' => '#333'],
        'nocomp'      => ['bg' => '#333333', 'text' => '#fff'],
        'booked'      => ['bg' => '#333333', 'text' => '#fff'],
        'busy'        => ['bg' => '#333333', 'text' => '#fff'],
        'busy_admin'  => ['bg' => '#1662BD', 'text' => '#fff'],
        'locked'      => ['bg' => '#3366CC', 'text' => '#fff'],
        'confirmed_t' => ['bg' => '#33497A', 'text' => '#fff'],
        'confirmed_p' => ['bg' => '#4CA64C', 'text' => '#fff'],
    ];

    /**
     * @var array
     */
    public static $places = [
        'SD'  => 'San Donà',
        'MU'  => 'Musile',
        'MS'  => 'Mussetta',
        'CEG' => 'Ceggia',
        'TOR' => 'Torre di Mosto',
    ];

    /**
     * @var array
     */
    public static $licenses = [
        'A' => 'A',
        'B' => 'B',
        'C' => 'C',
        'D' => 'D',
        'X' => 'Sarebbe comodo avere una lista con tutte le patenti che vengono gestite e le loro sigle corrette, es A1/2/3, B, BS...',
    ];

    /**
     * @var array
     */
    public static $exam_status_select = [
        ''       => '',
        'idoneo' => 'Idoneo',
        'nonid'  => 'Non Idoneo',
        'assen'  => 'Assente',
    ];

    /**
     * {@inheritdoc}
     */
    protected function getDefaultOptions()
    {
        return [
            'avg_time_esami_teoria' => 30,
        ];
    }
}
