<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Autoscuola
 */

namespace Application\Autoscuola\Model;

use ActiveRecord\Base;

/**
 * LocationUser
 *
 * @property int                                    $location_id
 * @property int                                    $user_id
 * @property string                                 $typology
 * @property \Application\Autoscuola\Model\Location $location
 * @property \Application\Core\Model\Account        $user
 */
class LocationUser extends Base
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'autoscuola_locations_users';

    /**
     * Chiave primaria.
     *
     * @var array
     */
    public static $primary_key = ['location_id', 'user_id', 'typology'];

    /**
     * Relazione `belongs_to`.
     *
     * @var array
     */
    public static $belongs_to = [
        ['location', 'model' => \Application\Autoscuola\Model\Location::class],
        ['user', 'model' => \Application\Core\Model\Account::class],
    ];
}
