<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Autoscuola
 */

namespace Application\Autoscuola\Model;

use ActiveRecord\Base;

/**
 * Location
 *
 * @property int    $id
 * @property string $name
 * @property string $abbreviation
 * @property int    $typology
 */
class Location extends Base
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'autoscuola_locations';

    /**
     * @var array
     */
    public static $typologies = [
        'Sede',
        'Località',
        'Mezzo',
    ];

    /**
     * @return Location[]
     */
    public static function getStartPlacesSelectOptions()
    {
        $locations = [];

        /** @var Location $location */
        foreach (Location::all(['order' => 'typology ASC, abbreviation ASC']) as $location) {
            $locations[Location::$typologies[$location->typology]][$location->id] = "{$location->abbreviation} ({$location->name})";
        }

        return $locations;
    }
}
