<?php

namespace Application\Autoscuola\Handler\View;

use Application\Autoscuola\Model\Location;
use Application\Calendar\Handler\View\Base;
use Application\Calendar\Handler\ViewInterface;
use Application\Calendar\Model\Calendar;

class ResourceDay extends Base implements ViewInterface
{
    public function getView()
    {
        $path = $this->site_module->path;
        $calendars = $this->data_handler->getCalendars();

        $calendar_ids = [];
        $resources = [];
        foreach ($calendars as $calendar) {
            $calendar_ids[] = $calendar->id;
            $resources[] = [
                'id'   => $calendar->id,
                'name' => shorter_string($calendar->title, 15),
            ];
        }

        $events = [
            'url'  => url("{$path}getevents/"),
            'data' => [
                'calendars' => $calendar_ids,
                'handler'   => $this->data_handler->getClassPath(),
            ],
            'type' => 'POST',
        ];
        $calendar_options['events'] = $events;

        $json = json_encode(array_merge([
            'resources'    => $resources,
            'events'       => $events,
            'selectable'   => true,
            'selectHelper' => true,
            'handler'      => $this->data_handler->getClassPath(),
        ], $this->calendar_options));

        $places = [];
        foreach (Location::all() as $location) {
            $places[$location->id] = $location->abbreviation;
        }

        $places = json_encode($places);

        $calendar_icon = themes_url('/images/calendar.png');

        $code = <<<JS
var o = $json, places = $places;

function myEventCustomFieldsCallback(calEvent, popup) {
	$('[name="custom_start_place"]', popup).val(calEvent.custom_start_place);
}

function myEventSaveCustomFieldsCallback(calEvent, popup, data) {
	calEvent.custom_start_place = $('[name="custom_start_place"]', popup).val();

	data['custom_start_place'] = calEvent.custom_start_place;

	return data;
}

function myEventRenderCallback(calEvent, element) {
	var head = element.find('.fc-event-head'), label, title, desc = '', p = calEvent.participants, place = calEvent.custom_start_place;

	if (p === undefined) p = [];

	if (p.length > 1) {
		title = '<div><span class="fc-custom-event-type">' + places[place] + '</span> <span class="fc-custom-event-user">Più partecipanti...</span></div>';
		desc = '<ul class="fc-custom-event-user-list">';
		$.each(calEvent.participants, function(index, participant) {
			desc += '<li>' + participant.label + '</li>';
		});
		desc += '<ul>';
	} else {
		if (typeof calEvent.participants[0] !== 'undefined' ) {
			label = calEvent.participants[0].label;
		} else {
			label = 'Nessun partecipante';
		}

		title = '<div><span class="fc-custom-event-type">' + places[place] + '</span> <span class="fc-custom-event-user">' + label + '</span></div>';
		desc = '<span>' + calEvent.description + '</span>';
	}

	head.find('.fc-event-time').hide();
	head.append(title);

	element.find('.fc-event-content').append(desc);
}

o.eventCustomFieldsCallback = myEventCustomFieldsCallback;
o.eventSaveCustomFieldsCallback = myEventSaveCustomFieldsCallback;
o.eventRenderCallback = myEventRenderCallback;

$(document).ready(function() {
	var cal = $('#calendar'), title, dp;
	cal.ponghoFullCalendar(o);

	title = $('.fc-header-title', cal);
	dp = $('<input type="hidden" />');

	dp.appendTo(title).datepicker({
		showOn: 'button',
		beforeShow: function(input, inst) {
			$(input).val(new XDate(cal.fullCalendar('getDate')).toString('yyyy-MM-dd'));
		},
		buttonImage: '$calendar_icon',
		buttonImageOnly: true,
		buttonText: 'Clicca per scegliere una data',
		dateFormat: "yy-mm-dd",
		onSelect: function(dateText, inst) {
			cal.fullCalendar('gotoDate', new Date(dateText));
		}
	});

	title.on('click', function(event) {
		dp.datepicker('show');
	});
});

JS;

        $this->populateHead($code);

        return $calendars;
    }

    public static function getClassPath()
    {
        return 'Application\\Calendar\\Handler\\View\\ResourceDay';
    }
}
