<?php

namespace Application\Autoscuola\Handler\View;

use Application\Autoscuola\Model\Location;
use Application\Calendar\Handler\View\Base;
use Application\Calendar\Handler\ViewInterface;
use Application\Calendar\Model\Calendar;

class GuideStudent extends Base implements ViewInterface
{
    public function getView()
    {
        $path = $this->site_module->path;
        $calendars = $this->data_handler->getCalendars();
        $filters = $this->data_handler->getFilters();

        $calendar_ids = [];
        $resources = [];
        foreach ($calendars as $calendar) {
            $calendar_ids[] = $calendar->id;
            $resources[] = [
                'id'   => $calendar->id,
                'name' => shorter_string($calendar->title, 15),
            ];
        }

        $events = [
            'url'  => url("{$path}getevents/"),
            'data' => [
                'calendars' => $calendar_ids,
                'handler'   => $this->data_handler->getClassPath(),
                'filters'   => $this->data_handler->getFilters(),
            ],
            'type' => 'POST',
        ];
        $calendar_options['events'] = $events;

        $json = json_encode(array_merge([
            'resources'    => $resources,
            'events'       => $events,
            'selectable'   => true,
            'selectHelper' => true,
        ], $this->calendar_options));

        $places = [];
        foreach (Location::all() as $location) {
            $places[$location->id] = $location->abbreviation;
        }

        $places = json_encode($places);

        $user_id = $this->user->id;
        $user_label = $this->user->fullname;
        $location_id = $filters['location_id'];
        $calendar_icon = themes_url('/images/calendar.png');

        $code = <<<JS
var o = $json, places = $places;

function myEventClickCallback(calEvent, jsEvent, view) {
	calEvent.pongho_action = 'add';

	if ( calEvent.isBooked && !calEvent.isMyBooking ) {
		alert('La guida è già prenotata');
		return false;
	}
	if ( !calEvent.isCompatible ) {
		alert('La guida non è compatibile con il luogo di partenza impostato');
		return false;
	}
	if ( calEvent.isLocked ) {
		alert('Non è possibile prenotare una guida in questo orario');
		return false;
	}
	if ( calEvent.isMyBooking ) {
		if (confirm('Vuoi rimuovere la prenotazione?')){
			calEvent.pongho_action = 'delete';
		} else {
			return false;
		}
	}

	calEvent.participants.push({
		'user_id': $user_id,
		'label': '$user_label',
		'status': 'active',
		'custom_created_at': new XDate().toString('dd-MM-yyyy')
	});

	calEvent.author = $user_id;
	calEvent.custom_start_place = '$location_id';

	var data = {
		'action': calEvent.pongho_action,
		'author_id': calEvent.author,
		'calendar_id': (typeof calEvent.resourceId != 'undefined' ? calEvent.resourceId : calEvent.calendar),
		'category_id': (typeof calEvent.resourceId != 'undefined' && calEvent.resourceId === calEvent.calendar ? calEvent.category : undefined),
		'title': calEvent.title,
		'content': calEvent.description,
		'start_date_at': new XDate(calEvent.start).toString('yyyy-MM-dd HH:mm'),
		'end_date_at': new XDate(calEvent.end).toString('yyyy-MM-dd HH:mm'),
		'is_all_day': calEvent.allDay ? 1 : 0,
		'status': calEvent.status,
		'handler': calEvent.handler,
		'filters': calEvent.filters,
		'custom_start_place': calEvent.custom_start_place
	};
	myEditEvent(view.calendar, calEvent, data, view.calendar.options.event_save_url);
}

function myEditEvent(cal, calEvent, data, url) {
	if (data.title !== '') {
		data.id = calEvent.id;

		data.participants = [];
		for ( index in calEvent.participants ) {
			if (calEvent.participants.hasOwnProperty(index)) {
				var obj = calEvent.participants[index];
				data.participants.push(obj);
			}
		}

		$.post(url, data, function(d) {
			if (d.error) {
				alert(d.message);

				cal.refetchEvents();
			} else {
				calEvent.author = d.author_id;
				calEvent.calendar = d.calendar_id;
				calEvent.category = d.category_id;
				calEvent.title = d.title;
				calEvent.description = d.content;
				calEvent.start = d.start_date_at;
				calEvent.end = d.end_date_at;
				calEvent.allDay = d.is_all_day;
				calEvent.status = d.status;
				calEvent.textColor = d.text_color;
				calEvent.color = d.bg_color;
				calEvent.participants = d.participants;
				calEvent.resourceId = d.calendar_id;

				if (data.action === 'add') {
					calEvent.id = d.id;

					cal.renderEvent(calEvent);
				} else if (data.action === 'edit') {
					cal.updateEvent(calEvent);
				} else {
					cal.removeEvents(calEvent.id);
				}
			}
		});
	}
	cal.refetchEvents();
}

function myEventRenderCallback(calEvent, element) {
	var head = element.find('.fc-event-head'), label, title, desc = '', p = calEvent.participants, place = calEvent.custom_start_place;

	if (p === undefined) p = [];

	title = '<div><span class="fc-custom-event-type">' + (places[place] || '') + '</span> <span class="fc-custom-event-user">Libero</span></div>';

	if (calEvent.isMyBooking) {
		if (calEvent.isLocked) {
			title = '<div title="La tua guida, non è più modificabile"><span class="fc-custom-event-type">' + (places[place] || '') + '</span> <span class="fc-custom-event-user">' + calEvent.participants[0].label + '</span></div>';;
		} else {
			title = '<div title="La tua guida, clicca per cancellare la prenotazione"><span class="fc-custom-event-type">' + (places[place] || '') + '</span> <span class="fc-custom-event-user">' + calEvent.participants[0].label + '</span></div>';;
		}
	} else {
		if (calEvent.isBooked) {
			title = '<div title="La guida è già prenotata">Occupato</div>';
		} else {
			if (calEvent.isLocked) {
				title = '<div>Non prenotabile</div>';
			} else {
				if (calEvent.isCompatible) {
					title = '<div><span class="fc-custom-event-type">' + (places[place] || '') + '</span> <span class="fc-custom-event-user">Libero</span></div>'
				} else {
					title = '<div title="Non compatibile con il luogo di partenza impostato">Non compatibile</div>';
				}
			}
		}
	}

	head.find('.fc-event-time').hide();
	head.append(title);

	element.find('.fc-event-content').html(desc);
}

o.eventClickCallback = myEventClickCallback;
o.eventRenderCallback = myEventRenderCallback;

$(document).ready(function() {
	var cal = $('#calendar'), title, dp;
	cal.ponghoFullCalendar(o);

	title = $('.fc-header-title', cal);
	dp = $('<input type="hidden" />');

	dp.appendTo(title).datepicker({
		showOn: 'button',
		beforeShow: function(input, inst) {
			$(input).val(new XDate(cal.fullCalendar('getDate')).toString('yyyy-MM-dd'));
		},
		buttonImage: '$calendar_icon',
		buttonImageOnly: true,
		buttonText: 'Clicca per scegliere una data',
		dateFormat: "yy-mm-dd",
		onSelect: function(dateText, inst) {
			cal.fullCalendar('gotoDate', new Date(dateText));
		}
	});

	title.on('click', function(event) {
		dp.datepicker('show');
	});
});

JS;

        $this->populateHead($code);

        return $calendars;
    }

    public static function getClassPath()
    {
        return \Application\Autoscuola\Handler\View\GuideStudent::class;
    }
}
