<?php

namespace Application\Autoscuola\Handler\View;

use Application\Calendar\Handler\View\Base;
use Application\Calendar\Handler\ViewInterface;

class EsamiTeoria extends Base implements ViewInterface
{
    public function getView()
    {
        $path = $this->site_module->path;
        $calendars = $this->data_handler->getCalendars();

        $calendar_ids = [];
        foreach ($calendars as $calendar) {
            $calendar_ids[] = $calendar->id;
        }

        $events = [
            'url'  => url("{$path}getevents/"),
            'data' => [
                'calendars' => $calendar_ids,
                'handler'   => $this->data_handler->getClassPath(),
            ],
            'type' => 'POST',
        ];
        $calendar_options['events'] = $events;

        $json = json_encode(array_merge([
            'handler' => $this->data_handler->getClassPath(),
            'events'  => $events,
        ], $this->calendar_options));

        $code = <<<JS
function myAfterPopupOpenAddCallback(popup, cal, calEvent) {
	var start = $('[name="start_date_at"]', popup);

	start.val(new XDate(calEvent.start).toString('yyyy-MM-dd ') + start.data('hours'));
}

function myBeforePopupCloseCallback(popup, cal, calEvent) {
	var start = $('[name="start_date_at"]', popup),
		end = $('[name="end_date_at"]', popup);

	end.val(new XDate(start.val()).addMinutes(30).toString('yyyy-MM-dd HH:mm'));
}

function myPopupCloseCustomActionCallback(cal, calEvent, p, data, url) {
	calEvent.status = 'closed';
	data.status = calEvent.status;
	data.action = 'edit';
}

function myEventRenderCallback(calEvent, element) {
	var p = calEvent.participants || [], content = $('<div>'), desc = '';
	if (calEvent.description) {
		desc = '<span>' + calEvent.description + '</span>';
	}

	if (p.length > 0) {
		desc += '<ul class="fc-custom-event-user-list">';
		$.each(calEvent.participants, function(index, participant) {
			desc += '<li>' + participant.label + '</li>';
		});
		desc += '<ul>';
	}

	//element.find('.fc-event-content').append(desc);
	content.addClass('fc-event-content').append(desc);

	element.find('.fc-event-inner').append(content);
}

var o = {$json};
o.eventRenderCallback = myEventRenderCallback;
o.afterPopupOpenAddCallback = myAfterPopupOpenAddCallback;
o.beforePopupCloseCallback = myBeforePopupCloseCallback;
o.popupCloseCustomActionCallback = myPopupCloseCustomActionCallback;

\$(document).ready(function() {\$('{$this->calendar_container}').ponghoFullCalendar(o);});
JS;

        $this->populateHead($code);

        return $calendars;
    }

    public static function getClassPath()
    {
        return \Application\Autoscuola\Handler\View\EsamiTeoria::class;
    }
}
