<?php

namespace Application\Autoscuola\Handler\Data;

use Application\Autoscuola\Model\Location;
use Application\Autoscuola\Model\ModuleSite as Autoscuola;
use Application\Calendar\Handler\Data\Base;
use Application\Calendar\Model\Calendar;
use Application\Calendar\Model\CalendarCategory;
use Application\Calendar\Model\CalendarEvent;
use Application\Calendar\Model\CalendarEventUser;
use Application\Calendar\Model\CalendarUser;
use Application\Core\Model\Role;
use Pongho\DependencyInjection\Container;
use Pongho\Utilities\DateTime;

class BachecaInsegnante extends Base
{
    public static function getClassPath()
    {
        return \Application\Autoscuola\Handler\Data\BachecaInsegnante::class;
    }

    public function getCalendars()
    {
        $calendars = [];

        switch ($this->user->role_id) {
            case Autoscuola::ROLE_TEACHER_T:
                $calendari = [Autoscuola::CALENDAR_TEORIA];
                break;

            case Autoscuola::ROLE_TEACHER_P:
                $calendari = [Autoscuola::CALENDAR_PRATICA];
                break;

            case Autoscuola::ROLE_TEACHER:
                $calendari = [Autoscuola::CALENDAR_TEORIA, Autoscuola::CALENDAR_PRATICA];
                break;
        }

        $options = [
            'conditions' => ['id IN (' . implode(',', $calendari) . ') OR owner_id = :owner', 'owner' => $this->user->id],
        ];

        foreach (Calendar::all($options) as $calendar) {
            $calendar->is_editable = false;
            $calendar->events = [];

            $calendars['calendar-' . $calendar->id] = $calendar;
        }

        return $calendars;
    }

    /**
     * {@inheritdoc}
     */
    public function getEvents(/* args */)
    {
        $options = func_get_arg(0);

        if (!is_array($options)) {
            throw new \InvalidArgumentException('The first argument must be an array');
        }

        $events = [];
        foreach (CalendarEvent::all($options) as $event) {
            $events[] = $this->makeEvent($event, false);
        }

        return $events;
    }

    /**
     * Carica il template del popup, utilizzato dalla chiamata AJAX in AjaxController
     *
     * @static
     * @access public
     *
     * @param array                                 $data i dati provenienti dal POST, gli eventi sono già gestiti dal parsePost()
     * @param \Pongho\DependencyInjection\Container $container
     */
    public static function getPopupTemplate(array $data, Container $container)
    {
        $site_module = $container->get('controller')->getSiteModule();
        $path = $site_module->path;

        if ($data['action'] === 'add') {
            $event = new CalendarEvent();
            $event->calendar_id = $data['resource_id'];
            $event->title = 'Occupato';
            $event->start_date_at = new DateTime($data['start']);
            $event->end_date_at = new DateTime($data['end']);
        } else {
            $event = CalendarEvent::find($data['event_id']);
        }

        $container->get('theme_view')
            ->setTemplate('calendar/popups/riepilogo_esame_teoria.php')
            ->assignVars([
                'form_action'      => url("{$path}event/"),
                'autocomplete_url' => url("{$path}autocomplete/"),
                //'autocomplete_filter_roles'	=> json_encode(array(Autoscuola::ROLE_STUDENT_T)),
                'categories_url'   => url("{$path}categories/"),
                'category_select'  => Calendar::getCategoriesSelectOptions($event->calendar_id),
                'event'            => $event,
                'places'           => Location::getStartPlacesSelectOptions(),
            ]);
    }
}
