<?php

namespace Application\Autoscuola\Form;

use Application\Admin\Form\ChecklistManyToManyField;
use Application\Autoscuola\Model\Location;
use Application\Autoscuola\Model\LocationUser;
use Application\Core\Model\Account;

class ChecklistLuoghiIstruttori extends ChecklistManyToManyField
{
    public function deleteRelations()
    {
        $relations = LocationUser::all([
            'conditions' => ['user_id = :user AND typology = :typology', 'user' => $this->model->id, 'typology' => 'istruttori'],
        ]);

        foreach ($relations as $relation) {
            $relation->delete();
        }
    }

    public function setRelations(array $foreigns)
    {
        $that = $this;
        $model_id = $this->model->id;

        LocationUser::transaction(function () use ($that, $foreigns, $model_id): void {
            $that->deleteRelations();

            foreach ($foreigns as $foreign_id) {
                LocationUser::create([
                    'user_id'     => $model_id,
                    'location_id' => $foreign_id,
                    'typology'    => 'istruttori',
                ]);
            }
        });
    }

    public function getRelations()
    {
        if ($this->relations === null) {
            $options = [
                'joins'      => 'LEFT JOIN ' . LocationUser::tableName() . ' AS r ON `from`.id = r.location_id',
                'conditions' => [
                    "r.user_id = :user AND r.typology = :typology",
                    'user'     => $this->model->id,
                    'typology' => 'istruttori',
                ],
            ];

            $this->relations = [];
            foreach (Location::all($options) as $relation) {
                $this->relations[$relation->id] = $relation;
            }
        }

        return $this->relations;
    }
}
