<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widgets\Stats\View\GoogleChart;

use Application\Admin\Widgets\Stats\ReportInterface;
use Application\Admin\Widgets\Stats\ViewInterface;

/**
 * Chart
 */
class Chart implements ViewInterface
{
    /**
     * @var string
     */
    protected $type;

    /**
     * @var array
     */
    protected $header_labels = array();

    /**
     * @var array
     */
    protected $options = array();

    /**
     * @param string $type
     * @param array  $header_labels
     * @param array  $options
     */
    public function __construct($type, array $header_labels = array(), array $options = array())
    {
        $this->type = $type;
        $this->options = $options;
        $this->header_labels = $header_labels;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * {@inheritdoc}
     */
    public function renderReport(ReportInterface $report, $widget_key)
    {
        $result = array($this->header_labels);

        foreach ($report->getData() as $data) {
            $row = array_merge($data['x'], $data['y']);

            $result[] = $row;
        }

        $json = json_encode(
            array(
                'report' => $result,
                'chart'  => $this->type,
                'opts'   => $this->options,
            )
        );

        return <<<HTML
<script>var Pongho = Pongho || {}; Pongho.widgets = Pongho.widgets || {}; Pongho.widgets['{$widget_key}'] = {$json};</script>
HTML;
    }
}
