<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widget;

use Application\Core\Container;
use Pongho\Http\Exception\HttpNotFoundException;
use Pongho\Http\Request;

/**
 * Widget base per la dashboard.
 */
abstract class Widget
{
    /**
     * Contenitore delle dipendenze.
     *
     * @var \Application\Core\Container
     */
    protected $container;

    /**
     * Costruttore.
     *
     * @param \Application\Core\Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * Restituisce la chiave del widget.
     *
     * La chiave è un nome identificativo di ogni widget.
     *
     * @return string
     * @throws \RuntimeException Se la chiave non è specificata.
     */
    abstract public function getKey();

    /**
     * Restituisce il nome del Widget.
     *
     * Il nome viene utilizzato come titolo del widget all’interno della dashboard.
     *
     * @return string
     */
    abstract public function getName();

    /**
     * Restituisce quante colonne occupa il widget.
     *
     * @return integer Può essere 1 oppure 2.
     */
    abstract public function getColumns();

    /**
     * Restituisce il codice HTML per il rendering del widget.
     *
     * @abstract
     * @access public
     * @return string
     */
    abstract public function render();

    /**
     * Imposta le intestazioni.
     */
    public function setHeaders()
    {
    }

    /**
     * Gestisce le richieste HTTP.
     *
     * Alcuni widget possono avere la necessità di poter gestire chiamate HTTP verso Pongho.
     *
     * L’URL della chiamata deve iniziare con ./pongho/widget/{widget-key}/ per arrivare a questo metodo.
     *
     * @param \Pongho\Http\Request $request
     * @throws \Pongho\Http\Exception\HttpNotFoundException
     * @return \Pongho\Http\Response
     */
    public function handleRequest(Request $request)
    {
        throw new HttpNotFoundException();
    }
}
