<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widget;

use Application\Admin\Widget\Stats\Collection;
use Pongho\EventDispatcher\Event;

/**
 * StatsWidget
 */
class StatsWidget extends Widget
{
    /**
     * {@inheritdoc}
     */
    public function getKey()
    {
        return 'statsreport';
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return $this->container->getService('translator')->trans('Pongho statistics');
    }

    /**
     * {@inheritdoc}
     */
    public function getColumns()
    {
        return 1;
    }

    /**
     * {@inheritdoc}
     */
    public function render()
    {
        $stats = new Collection();

        /**
         * @var $dispatcher \Pongho\EventDispatcher\EventDispatcher
         * @var $event      \Pongho\EventDispatcher\Event
         * @var $stat       \Application\Admin\Widget\Stats\StatInterface
         */
        $dispatcher = $this->container->getService('event_dispatcher');
        $event = new Event($this, 'admin.dashboard.widgets.filter_stats');
        $stats = $dispatcher->filter($event, $stats)->getReturnValue();

        $html = '';
        /** @var \Application\Admin\Widget\Stats\Stat */
        foreach ($stats as $stat) {
            $html .= $stat->render();
        }

        return '<div id="statsreport-table">' . $html . '</div>';
    }
}
