<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Admin\Utilities
 */

namespace Application\Admin\Utilities;

use Application\Core\Model\Site;
use Pongho\Http\Request;

/**
 * Class PonghoUrl
 */
class PonghoUrl
{
    /**
     * @var \Application\Core\Model\Site
     */
    protected $site;

    /**
     * @var \Pongho\Http\Request
     */
    protected $request;

    /**
     * @var ContentLanguage
     */
    protected $content_language;

    /**
     * @param Site            $site
     * @param Request         $request
     * @param ContentLanguage $contentLanguage
     */
    public function __construct(Site $site, Request $request, ContentLanguage $contentLanguage)
    {
        $this->site = $site;
        $this->request = $request;
        $this->content_language = $contentLanguage;
    }

    /**
     * @param        $url
     * @param string $arg_separator
     * @return string
     * @throws \InvalidArgumentException
     */
    public function url($url, $arg_separator = '&amp;')
    {
        $url = '/' . ltrim($url, '/');

        if (strpos($url, '/pongho/') === 0) {
            throw new \InvalidArgumentException(sprintf('Il metodo `%s` aggiunge automaticamente il prefisso `/pongho/` agli indirizzi passati.', __METHOD__));
        }

        $info = parse_url($url);
        $qs = array();

        if (isset($info['query'])) {
            parse_str($info['query'], $qs);
        }

        $qs['language'] = $this->content_language->getId();
        $qs['site'] = $this->site->id;

        return pongho_url($info['path'] . '?' . http_build_query($qs, null, $arg_separator));
    }

    /**
     * Restituisce l'url corrente.
     *
     * @param string $arg_separator
     * @return string
     */
    public function currentUrl($arg_separator = '&amp;')
    {
        return $this->url(substr($this->request->getRelativeUri(), 7), $arg_separator);
    }
}
