<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Admin
 */

namespace Application\Admin\Updates;

use Application\Admin\Model\AdminModule;
use Application\Core\Model\Permit;
use Application\Core\Model\PermitRole;
use Updates\BaseUpdate;

/**
 * Class Update90
 */
class Update90 extends BaseUpdate
{
    /**
     * Esegue l'aggiornamento
     */
    public function commit()
    {
        /*
         * Creo il nuovo pannello delle opzioni con il relativo permesso
         */

        /** @var \Application\Core\Model\Permit $options_permit */
        if (($options_permit = Permit::findByKey('admin.options')) === null) {
            $options_permit = Permit::create(
                array(
                    'key'        => 'admin.options',
                    'is_enabled' => true,
                )
            );
        }

        /** @var \Application\Admin\Model\AdminModule $options_panel */
        if (($options_panel = AdminModule::findPanel('options')) === null) {
            $options_panel = AdminModule::create(
                array(
                    'permit_id' => $options_permit->id,
                    'position'  => 10000,
                    'name'      => 'options',
                    'css_class' => 'settings',
                )
            );
        }

        $affected_permits = array();

        /*
         * Sposto nel nuovo pannello le voci già presenti
         */

        if ($menus_item = AdminModule::findByName('menus')) {
            $menus_item->parent_id = $options_panel->id;
            $menus_item->position = 10;
            $menus_item->save();

            if ($menus_item->permit_id) {
                $affected_permits[] = $menus_item->permit_id;
            }
        }

        if ($slides_item = AdminModule::findByName('slides')) {
            $slides_item->parent_id = $options_panel->id;
            $slides_item->position = 20;
            $slides_item->save();

            if ($slides_item->permit_id) {
                $affected_permits[] = $slides_item->permit_id;
            }
        }

        if ($redirects_item = AdminModule::findByName('seo_redirects')) {
            $redirects_item->parent_id = $options_panel->id;
            $redirects_item->position = 30;
            $redirects_item->save();

            if ($redirects_item->permit_id) {
                $affected_permits[] = $redirects_item->permit_id;
            }
        }

        if ($translations_item = AdminModule::findByName('translations')) {
            $translations_item->parent_id = $options_panel->id;
            $translations_item->position = 40;
            $translations_item->save();

            if ($translations_item->permit_id) {
                $affected_permits[] = $translations_item->permit_id;
            }
        }

        if ($contactforms_item = AdminModule::findByName('contact_forms_list')) {
            $contactforms_item->parent_id = $options_panel->id;
            $contactforms_item->name = 'contact_forms';
            $contactforms_item->position = 50;
            $contactforms_item->save();

            if ($contactforms_item->permit_id) {
                $affected_permits[] = $contactforms_item->permit_id;
            }
        }

        /*
         * Sposto nel pannello delle impostazioni le voci modificabili solo dal founder
         */

        $settings_panel = AdminModule::findPanel('settings');

        // Mi assicuro che il pannello delle impostazioni stia in fondo
        $settings_panel->position = 99999;
        $settings_panel->save();

        if ($cms_item = AdminModule::findByName('cms_settings')) {
            $cms_item->parent_id = $settings_panel->id;
            $cms_item->position = 50;
            $cms_item->permit_id = null;
            $cms_item->save();
        }

        if ($customfield_item = AdminModule::findByName('custom_fields')) {
            $customfield_item->parent_id = $settings_panel->id;
            $customfield_item->position = 60;
            $customfield_item->permit_id = null;
            $customfield_item->save();
        }

        if ($seo_item = AdminModule::findByName('seo_general')) {
            $seo_item->parent_id = $settings_panel->id;
            $seo_item->position = 70;
            $seo_item->permit_id = null;
            $seo_item->name = 'seo';
            $seo_item->save();
        }

        /*
         * Imposto il permesso per l'accesso al pannello "opzioni" a tutti i ruoli che avevano almeno uno dei permessi delle singole voci
         */

        $options = array(
            'select' => 'role_id',
            'conditions' => array(
                'permit_id IN (' . implode(',', $affected_permits) . ')',
            ),
            'group' => 'role_id',
        );

        /** @var \Application\Core\Model\Role $role */
        foreach (PermitRole::all($options) as $role) {
            PermitRole::create(
                array(
                    'permit_id' => $options_permit->id,
                    'role_id'   => $role->role_id,
                )
            );
        }

        /*
         * Elimino le voci e i pannelli non più usati
         */
        if ($panel = AdminModule::findPanel('design')) {
            foreach ($panel->children() as $item) {
                $item->delete();
            }

            $panel->delete();
        }

        if ($panel = AdminModule::findPanel('seo')) {
            foreach ($panel->children() as $item) {
                $item->delete();
            }

            $panel->delete();
        }

        if ($panel = AdminModule::findPanel('contact_forms')) {
            foreach ($panel->children() as $item) {
                $item->delete();
            }

            $panel->delete();
        }

        if ($panel = AdminModule::findPanel('cms')) {
            foreach ($panel->children() as $item) {
                $item->delete();
            }

            $panel->delete();
        }

        /*
         * Rimuovo qualsiasi permesso per vedere il pannello delle impostazioni
         */
        $options = array(
            'conditions' => array(
                'permit_id = :permit',
                'permit' => $settings_panel->permit_id,
            ),
        );

        foreach (PermitRole::all($options) as $permit_role) {
            $permit_role->delete();
        }

        echo '<span style="color: red;">Sono stati modificati i permessi per i ruoli, fai un controllo ... </span>';
    }
}
