<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Admin
 */

namespace Application\Admin\Updates;

use Application\Admin\Model\AdminModule;
use Application\Core\Model\Translation;
use Updates\BaseUpdate;

/**
 * Class Update89
 */
class Update89 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        /** @var \Application\Admin\Model\AdminModule $settings_panel */
        if (($settings_panel = AdminModule::findPanel('settings')) !== null) {
            if (!AdminModule::findByName('apps')) {
                AdminModule::create(
                    array(
                        'parent_id'  => $settings_panel->id,
                        'position'   => 50,
                        'name'       => 'apps',
                        'path'       => 'apps',
                        'controller' => 'Application\\Core\\Controller\\Admin\\AppsController',
                    )
                );
            }
        }



        Translation::putTranslation('modules_apps', 'Gestione applicazioni', 'admin', 'it_IT');
        Translation::putTranslation('apps_settings', 'Gestione applicazioni', 'admin', 'it_IT');
        Translation::putTranslation('app_name', 'Applicazione', 'admin', 'it_IT');
        Translation::putTranslation('app_version', 'Versione', 'admin', 'it_IT');

        Translation::putTranslation('uninstall', 'Disinstalla', 'admin', 'it_IT');
        Translation::changeApplication('install', 'admin');
        Translation::changeApplication('installed', 'admin');
    }
}
