<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Admin
 */

namespace Application\Admin\Updates;

use Application\Core\Model\Account;
use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update71 extends SchemaUpdate
{
    /**
     * prepareSchema
     *
     * @param \Doctrine\DBAL\Schema\Schema $schema
     */
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->getTable('pongho_filters');
        $table->addColumn('user_id', 'integer', array('unsigned' => true, 'notnull' => false, 'default' => Account::ANONYMOUS));
        $table->addForeignKeyConstraint($schema->getTable('pongho_users'), array('user_id'), array('id'));
    }
}
