<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Admin
 */

namespace Application\Admin\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Class Update100
 *
 * Preparazione per l'eliminazione della tabella AdminModules che non viene più utilizzata a favore dell'AdminSidebar
 */
class Update100 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->getTable('pongho_admin_modules');

        // Rimuovo le relazioni esterne in modo da mantenere inalterata la tabella ma permettendo di modificare le altre
        // tabelle (rimuovendo record etc)
        foreach ($table->getForeignKeys() as $fk) {
            $table->removeForeignKey($fk->getName());
        }
    }
}
