<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Tests\Panels\Widgets;

use Application\Admin\Widgets\WidgetsCollection;
use Symfony\Component\DomCrawler\Crawler;

class WidgetsCollectionTest extends \PHPUnit_Framework_TestCase
{
    public function testCollection()
    {
        $coll = new WidgetsCollection();
        $this->assertFalse($coll->has('foo'));

        $widget = $this->getWidgetMock('foo');
        $coll->add($widget);

        $this->assertTrue($coll->has('foo'));
        $this->assertSame($widget, $coll->get('foo'));

        $coll->del('foo');
        $this->assertFalse($coll->has('foo'));
    }

    /**
     * @expectedException \InvalidArgumentException
     */
    public function testNotFoundException()
    {
        $coll = new WidgetsCollection();
        $coll->get('foo');
    }

    public function testTraversable()
    {
        $coll = new WidgetsCollection();
        $this->assertInstanceOf('\Traversable', $coll);

        $coll->add($this->getWidgetMock('foo'));
        $coll->add($this->getWidgetMock('bar'));

        $counter = 0;
        foreach ($coll as $panel) {
            $this->assertInstanceOf('Application\\Admin\\Widgets\\WidgetInterface', $panel);
            $counter++;
        }

        $this->assertEquals(2, $counter);
    }

    public function testRender()
    {
        $coll = new WidgetsCollection();

        $coll->add($this->getWidgetForRenderMock('foo-key', 'Foo Title', 'Foo Content', 2));
        $coll->add($this->getWidgetForRenderMock('bar-key', 'Bar Title', 'Bar Content', 1));
        $coll->add($this->getWidgetForRenderMock('baz-key', 'Baz Title', 'Baz Content', 1));

        $crawler = new Crawler($coll->render());

        $this->assertEquals(3, $crawler->filter('div.widget')->count());
        $this->assertEquals(2, $crawler->filter('div.widget-column1')->count());
        $this->assertEquals(1, $crawler->filter('div.widget-column2')->count());

        $this->assertEquals(3, $crawler->filter('div.widget h3')->count());
        $this->assertEquals(3, $crawler->filter('div.widget div.widget-content')->count());

        $this->assertEquals(1, $crawler->filter('#widget-foo-key')->count());
        $this->assertEquals(1, $crawler->filter('#widget-bar-key')->count());
        $this->assertEquals(1, $crawler->filter('#widget-baz-key')->count());
    }

    /**
     * @param string $key
     * @return \Application\Admin\Widgets\WidgetInterface
     */
    private function getWidgetMock($key)
    {
        $widget = $this->getMock('Application\\Admin\\Widgets\\WidgetInterface');

        $widget->expects($this->any())->method('getKey')->willReturn($key);

        return $widget;
    }

    /**
     * @param string $key
     * @param string $title
     * @param string $content
     * @param int    $columns
     * @return \Application\Admin\Widgets\WidgetInterface
     */
    private function getWidgetForRenderMock($key, $title, $content, $columns)
    {
        $widget = $this->getMock('Application\\Admin\\Widgets\\WidgetInterface');

        $widget->expects($this->exactly(2))->method('getKey')->willReturn($key);
        $widget->expects($this->once())->method('getTitle')->willReturn($title);
        $widget->expects($this->once())->method('getContent')->willReturn($content);
        $widget->expects($this->once())->method('getColumns')->willReturn($columns);

        return $widget;
    }
}
