<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widgets\Stats\View\GoogleChart;

function pongho_url($url)
{
    return $url;
}

namespace Application\Admin\Tests\Widgets\Stats\View\GoogleChart;

use Application\Admin\Widgets\Stats\View\GoogleChart\ChartFactory;

class ChartFactoryTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @dataProvider chartTypeProvider
     * @param string $method
     * @param string $type
     */
    public function testChartType($method, $type)
    {
        $head = $this->getMockBuilder('Pongho\\Template\\HeadHelper')
            ->disableOriginalConstructor()
            ->setMethods(array('addJavaScript', 'addJavaScriptInline'))
            ->getMock();

        /**
         * @var \Pongho\Template\HeadHelper $head
         */

        $factory = new ChartFactory($head);
        $chart = call_user_func(array($factory, $method), array(), array());

        $this->assertInstanceOf('Application\Admin\Widgets\Stats\View\GoogleChart\Chart', $chart);
        $this->assertEquals($type, $chart->getType());
    }

    public function chartTypeProvider()
    {
        return array(
            array('createComboChart', 'ComboChart'),
            array('createBarChart', 'BarChart'),
        );
    }

    public function testCreateManyChartLoadJsOnlyOnce()
    {
        $head = $this->getMockBuilder('Pongho\\Template\\HeadHelper')
            ->disableOriginalConstructor()
            ->setMethods(array('addJavaScript', 'addJavaScriptInline'))
            ->getMock();

        $head->expects($this->once())->method('addJavaScript');
        $head->expects($this->once())->method('addJavaScriptInline');

        /**
         * @var \Pongho\Template\HeadHelper $head
         */

        $factory = new ChartFactory($head);

        $factory->createBarChart(array(), array());
        $factory->createComboChart(array(), array());
    }
}
