<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Tests\Widgets\Stats;

use Application\Admin\Widgets\Stats\StatWidget;

class StatWidgetTest extends \PHPUnit_Framework_TestCase
{
    public function testWidget()
    {
        $report = $this->getMock('Application\\Admin\\Widgets\\Stats\\ReportInterface');

        $view = $this->getMock('Application\\Admin\\Widgets\\Stats\\ViewInterface');
        $view->expects($this->once())->method('renderReport')->with($report, 'foo')->willReturn('Foo Report Content');

        /**
         * @var \Application\Admin\Widgets\Stats\ViewInterface   $view
         * @var \Application\Admin\Widgets\Stats\ReportInterface $report
         */
        $widget = new StatWidget('foo', 'Foo Widget Title', 2, $view, $report);

        $this->assertInstanceOf('Application\\Admin\\Widgets\\WidgetInterface', $widget);

        $this->assertEquals('foo', $widget->getKey());
        $this->assertEquals('Foo Widget Title', $widget->getTitle());
        $this->assertEquals(2, $widget->getColumns());
        $this->assertEquals('Foo Report Content', $widget->getContent());
    }
}
