<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Tests\Widgets;

use Application\Admin\Widgets\PanelWidgetsCollection;

class PanelWidgetsCollectionTest extends \PHPUnit_Framework_TestCase
{
    public function testPanel()
    {
        $panel = new PanelWidgetsCollection('foo', 'Foo Title', $this->getWidgetsCollectionMock());

        $this->assertEquals('foo', $panel->getKey());
        $this->assertEquals('Foo Title', $panel->getTitle());
        $panel->getContent();
    }

    /**
     * @return \Application\Admin\Widgets\WidgetsCollection
     */
    private function getWidgetsCollectionMock()
    {
        $coll = $this->getMockBuilder('Application\\Admin\\Widgets\\WidgetsCollection')
            ->disableOriginalConstructor()
            ->getMock();

        $coll->expects($this->once())->method('render');

        return $coll;
    }
}
