<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package @todo
 */

/*
 * Mock della funzione pongho_url usata da \Application\Admin\Utilities\PonghoUrl
 * La funzione pongho_url utilizza il Kernel, perciò non può essere utilizzata nel test
 */
namespace Application\Admin\Utilities;

function pongho_url($url) {
    return $url;
}

namespace Application\Admin\Tests\PonghoUrl;

use Application\Admin\Utilities\ContentLanguage;
use Application\Admin\Utilities\PonghoUrl;
use Pongho\Http\Request;


class PonghoUrlTest extends \PHPUnit_Framework_TestCase
{
    public function testUrl()
    {
        $pongho_url = new PonghoUrl($this->getSiteMock(123), $this->getRequestMock('/'), $this->getContentLanguageMock(321));

        $url = $pongho_url->url('/path/', '&');
        $parse = parse_url($url, PHP_URL_QUERY);
        $query = array();
        parse_str($parse, $query);

        $this->assertEquals('/path/', parse_url($url, PHP_URL_PATH));
        $this->assertEquals(123, $query['site']);
        $this->assertEquals(321, $query['language']);
    }

    public function testCurrentUrl()
    {
        $pongho_url = new PonghoUrl($this->getSiteMock(1), $this->getRequestMock('/pongho/current/'), $this->getContentLanguageMock(1));

        $this->assertEquals('/current/', parse_url($pongho_url->currentUrl('&'), PHP_URL_PATH));
    }

    /**
     * @param      $site_id
     * @param null $domain
     * @return \Application\Core\Model\Site
     */
    protected function getSiteMock($site_id, $domain = null)
    {
        $site = $this->getMockBuilder('Application\\Core\\Model\\Site')
            ->disableOriginalConstructor()
            ->getMock();

        $site->expects($this->any())
            ->method('domain')
            ->will($this->returnValue($domain));

        $site->expects($this->any())
            ->method('__get')
            ->with('id')
            ->will($this->returnValue($site_id));

        return $site;
    }

    /**
     * @param $uri
     * @return Request
     */
    protected function getRequestMock($uri)
    {
        return Request::create($uri);
    }

    /**
     * @param $language_id
     * @return ContentLanguage
     */
    protected function getContentLanguageMock($language_id)
    {
        $content_language = $this->getMockBuilder('Application\\Admin\\Utilities\\ContentLanguage')
            ->disableOriginalConstructor()
            ->getMock();

        $content_language->expects($this->any())
            ->method('getId')
            ->will($this->returnValue($language_id));

        return $content_language;
    }
}
