<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Tests\AdminBar;

use Application\Admin\AdminBar\AdminBarBuilder;

class AdminBarBuilderTest extends \PHPUnit_Framework_TestCase
{
    public function testBuilder()
    {
        /** @var \Application\Admin\AdminBar\AdminBar $bar */
        $bar = $this->getMock('Application\\Admin\\AdminBar\\AdminBar');

        $filler = $this->getMock('Application\\Admin\\AdminBar\\FillerInterface');
        $filler->expects($this->once())
            ->method('fill')
            ->with($bar);

        /** @var \Application\Admin\AdminBar\FillerInterface $filler */
        $builder = new AdminBarBuilder($bar);
        $builder->add($filler);

        $this->assertSame($bar, $builder->build());
    }
}
