/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jQuery, Pongho, wysiwygOptions */

(function ($) {
    "use strict";

    var wysiwyg = {
        map: {
            'textarea.tinymce': 'normal',
            'textarea.tinymce-small': 'small',
            'textarea.tinymce-full': 'full',
            'textarea.tinymce-newsletter': 'newsletter'
        },
        attach: function (el) {
            wysiwyg._loop(el, function (id, textarea, optionsType) {
                wysiwyg._remove(id);

                textarea.css('height', function () {
                    return $(this).attr('rows') + 'em';
                }).tinymce(Pongho.wysiwyg.options[optionsType]);
            });
        },
        detach: function (el) {
            wysiwyg._loop(el, function (id) {
                wysiwyg._remove(id);
            });
        },
        _loop: function (el, callback) {
            if (Pongho.wysiwyg !== undefined) {
                $.each(this.map, function (selector, optionsType) {
                    el.find(selector).each(function () {
                        var textarea = $(this),
                            id = textarea.attr('id');

                        callback(id, textarea, optionsType);
                    });
                });
            }
        },
        _remove: function (id) {
            if (tinymce.get(id)) {
                tinymce.EditorManager.execCommand('mceRemoveEditor', false, id);
            }
        }
    };

    var onCreatePanel = function (el) {
        el.find('.repeater').repeater();

        wysiwyg.attach(el);

        el.find('.preview').colorbox({
            maxWidth: '90%',
            maxHeight: '90%',
            scalePhotos: true
        });

        el.find('.tabs').newTabs();
        el.find('.colorpicker').attachColorpicker();

        el.find('.panel-accordion').panelAccordion();

        //el.find('.link-type-select').linkType();
        el.find('.link-type-wrapper').newLinkType();

        el.find('.autosuggest').autosuggest();

        $('.repeater')
            .on('row_add', function (event, row) {
                //row.find('.link-type-select').linkType();
                row.find('.link-type-wrapper').newLinkType();
                wysiwyg.attach(row);
            }).on('sortstart', function (event, ui) {
                wysiwyg.detach(ui.item);
            }).on('sortstop', function (event, ui) {
                wysiwyg.attach(ui.item);
            });
    }, tabsPanel = $('.form-wrapper');


    if (Pongho.action !== 'add') {
        tabsPanel.ajaxForm().on('after-update', function () {
            onCreatePanel($(this));
        });
    }

    // Aggiungo la classe loading a tutti i button che effettuano il submit per indicare che sto facendo un'azione
    // La classe viene rimossa quando viene ricaricato il template, non serve rimuoverla manualmente
    tabsPanel.on('submit', 'form', function () {
        $(this).find('button[type="submit"]').addClass('busy');
    });

    onCreatePanel(tabsPanel);

}(jQuery));
