/**
 * Admin Javascript
 */

/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true, todo: true */
/*global $, Pongho */

/**
 * Serve per la gestione della conferma di uscita senza salvataggio dei dati tipo wordpress (chiede se si vuole lasciare la pagina senza salvare)
 */
var form_changed = false;

$(document).ready(function () {

    "use strict";

    (function () {
        var isSupported = function () {
            return window.FormData !== undefined && window.File !== undefined;
        };

        if (!isSupported()) {
            $('#browser-not-supported').show();
        }
    }());

    /**
     * Risolvo un problema con i campi file
     *
     * Se ho tanti campi file in una form, questi vengono TUTTI conteggiati per il max_file_uploads del php.ini (default = 20)
     * quindi se ho il 21° campo file valorizzato (es. ho caricato una slide in più), non figura nei $_FILES.
     *
     * Disabilitando il campo se vuoto, non viene inviato e tutto funziona
     */
    $('form').submit(function () {
        $('input:file[value=""]').attr('disabled', true);
    });

    /**
     * Lingua
     */
    var l = {
        delete_row: 'Sei sicuro di voler cancellare “{name}”?',
        saving: 'Salvataggio in corso...',
        show_pass: 'Visualizza password',
        hide_pass: 'Nascondi password'
    };


    /**
     * Funzioni principali
     */

        // http://www.quirksmode.org/js/cookies.html
    function createCookie(name, value, days) {
        var date, expires;

        if (days) {
            date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            expires = "; expires=" + date.toGMTString();
        } else {
            expires = "";
        }

        document.cookie = name + "=" + value + expires + "; path=/";
    }

    function readCookie(name) {
        var nameEQ = name + "=", ca = document.cookie.split(';'), i, c;

        for (i = 0; i < ca.length; i++) {
            c = ca[i];

            while (c.charAt(0) === ' ') {
                c = c.substring(1, c.length);
            }

            if (c.indexOf(nameEQ) === 0) {
                return c.substring(nameEQ.length, c.length);
            }
        }

        return null;
    }

    function eraseCookie(name) {
        createCookie(name, "", -1);
    }

    // Tabs
    $("ul.tabs:not(.nojs)").tabs();

    // Accordion sui pannelli richiudibili
    (function () {
        var title = $(".accordion h3");

        title.css("cursor", "pointer").prepend("<span>▸</span> ").data("open", false).next().hide();

        title.click(function () {
            var t = $(this);

            if (t.data("open")) {
                $("span", t).text("▸");
                t.data("open", false).next().slideUp();
            } else {
                $("span", t).text("▾");
                t.data("open", true).next().slideDown();
            }
        });
    }());

    // Accordion della sidebar
    (function () {
        var label = $('#sidebar-main > li > span').removeClass('open');

        label.click(function () {
            var t = $(this), ul = t.next();

            t.toggleClass('open');

            if (t.hasClass('open') || t.hasClass('active')) {
                ul.slideDown();
            } else {
                ul.slideUp();
            }
        });
    }());

    // Finestre modali
    $("a.modal").colorbox({iframe: true, width: 800, height: 600});
    $("a.modalinline").colorbox({inline: true, width: 720, height: 480});

    // Visualizzo la password
    $("#password").showpass({show: l.show_pass, hide: l.hide_pass});

    // Gestione tabelle
    $('table.pongho-table').tableManager({delete_row: l.delete_row});


    // Gestione elementi abilitati / disabilitati
    // @todo Da spostare nel tableManager
    $(".enabled input:checkbox, .disabled input:checkbox").click(function () {
        var tr = $(this).parents("tr");

        if (this.checked) {
            tr.removeClass("disabled").addClass("enabled");
        } else {
            tr.removeClass("enabled").addClass("disabled");
        }
    });


    // Sidebar
    $("#sidebar .section").each(function () {
        var s = $(this), t = $("h3", s), l = $("ul", s);

        if (l.length) {
            t.css("cursor", "pointer").append('<span class="toggle"/>');
        }

        if (!s.hasClass("active")) {
            l.hide();
        } else {
            s.addClass("open");
        }

        t.click(function () {
            if (t.hasClass("open")) {
                l.slideUp("fast", function () {
                    t.removeClass("open");
                });
            } else {
                l.slideDown("fast", function () {
                    t.addClass("open");
                });
            }
        });
    });


    /**
     * Gestione form
     */
    $("form.ajax").submit(function () {
        // Memorizzo l’oggetto form
        var f = $(this), ff = $("fieldset:first", f);

        // Salvataggio in corso...
        $.fn.colorbox({
            title: l.saving,
            width: 300,
            height: 200,
            html: '<div class="loading" />',
            open: true
        });

        // Eseguo la chiamata ajax
        $.post(this.action,
            f.formalize(),
            function (d) {
                if (d.errno) {
                    // Si è verificato un errore: visualizzo il messaggio in colorbox
                    $("#cboxLoadedContent").html('<div class="error message">' + d.errmsg + '</div>');

                    // Attendo 2 secondi
                    setTimeout(function () {
                        var a;

                        // Chiudo la finestra di colorbox
                        $.fn.colorbox.close();
                        // Visualizzo il messaggio di errore
                        $.fn.box(d.errmsg, "error", ff);

                        // Ciclo gli errori per evidenziare i campi errati
                        if (d.errors) {
                            $.each(d.errors, function (index) {
                                var $el = $("#" + index);

                                $el.parent().attr('class', 'errorpost');
                                $el.after('<span class="error_input_desc">' + d.errors[index] + '</span>');
                            });
                        }
                    }, 2000);
                } else {
                    // Visualizzo il messaggio nel colorbox
                    $("#cboxLoadedContent").html('<div class="message">' + d.msg + '</div>');

                    // Elimino gli eventuali messaggi di errore inseriti precedentemente
                    $(".error_input_desc").remove();
                    $(".errorpost").removeClass("errorpost").addClass("post");

                    // Attendo 2 secondi
                    setTimeout(function () {
                        if (d.redirect) {
                            window.location.href = d.redirect;
                            return;
                        }

                        $.fn.colorbox.close();
                        $.fn.box(d.msg, "info", ff);
                    }, 2000);
                }
            },
            'json');

        // Esco con false per non far ricaricare la pagina
        return false;
    });

    /**
     * Gestione dipendenze.
     */
    $('select.deps').change(function (event) {
        var $select = $(this),
            $opt = $select.find('option:selected'),
            target = $select.data('deps'),
            deps = $('.' + target);

        if (deps.length) {
            deps.hide();
            $('#' + target + '-' + $opt.data('dep')).show();
        }

        event.preventDefault();
    }).change();


    /**
     * Messaggio per la richiesta della conferma di eliminazione di un contenuto.
     */
    $('#delete-node').click(function (event) {
        if (!confirm('Stai per eliminare questo contenuto!')) {
            return false;
        }
    });


    /**
     * Gestione dei permalink come WordPress
     */
    $('.title-handler').each(function () {

        var field = $(this),
            title = field.find('.field-title'),
            handler = field.find('.permalink-handler'),
            permalink = handler.find('.slug-permalink'),
            slugHandle = permalink.find('.slug-editor-handle'),
            editor = handler.find('.slug-editor'),
            slugField = editor.find('.slug-field'),
            confirmBtn = editor.find('.slug-editor-confirm'),
            cancelBtn = editor.find('.slug-editor-cancel');

        if (title.val()) {
            handler.show();
        }

        function setSlug() {
            var url = title.data('req'),
                o = {
                    'object': title.data('object-id'),
                    'title': title.val(),
                    'url': slugField.val(),
                    'language': title.data('lang')
                };

            $.getJSON(url, o, function (data) {
                if (data.error) {
                    alert(data.message);
                } else {
                    slugField.val(data.slug);
                    slugHandle.text(data.slug);
                }
            });
        }

        title.on('blur', function () {
            setSlug();

            handler.show();

            if (!editor.is(':visible')) {
                permalink.show();
            }
        });

        slugHandle.on('click', function () {
            permalink.hide();
            editor.show();
        });

        confirmBtn.on('click', function () {
            setSlug();

            permalink.show();
            editor.hide();
        });

        cancelBtn.on('click', function () {
            permalink.show();
            editor.hide();
        });

    });


    /**
     * Gestione multisito
     */
    $('li#sites-settings a').colorbox({
        'width': 800,
        'height': 600,
        'iframe': true,
        'onClosed': function () {
            // ricarico la pagina quando chiudo il colorbox
            document.location.reload(true);
        }
    });


//  $('#permalink-field').blur(function (event) {
//      console.log('blur');
//      console.log(permalink_field_value);
//      // se annullo la modifica del campo viene sempre eseguito prima il blur e quindi non annulla la modifica (race condition)
//      $('#permalink-slug').text($('#permalink-field').val()).show();
//      $('#permalink-cancel, #permalink-field').hide();
//  });

    /**
     * DatePicker
     */
    (function () {

        // Traduzione in italiano (da spostare)
        $.datepicker.regional.it = {
            closeText: 'Chiudi',
            prevText: '‹ Prec',
            nextText: 'Succ ›',
            currentText: 'Oggi',
            monthNames: ['Gennaio', 'Febbraio', 'Marzo', 'Aprile', 'Maggio', 'Giugno', 'Luglio', 'Agosto', 'Settembre', 'Ottobre', 'Novembre', 'Dicembre'],
            monthNamesShort: ['Gen', 'Feb', 'Mar', 'Apr', 'Mag', 'Giu', 'Lug', 'Ago', 'Set', 'Ott', 'Nov', 'Dic'],
            dayNames: ['Domenica', 'Lunedì', 'Martedì', 'Mercoledì', 'Giovedì', 'Venerdì', 'Sabato'],
            dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mer', 'Gio', 'Ven', 'Sab'],
            dayNamesMin: ['Do', 'Lu', 'Ma', 'Me', 'Gi', 'Ve', 'Sa'],
            weekHeader: 'Sm',
            dateFormat: 'yy-mm-dd',
            firstDay: 1,
            isRTL: false,
            showMonthAfterYear: false,
            yearSuffix: ''
        };
        $.datepicker.setDefaults($.datepicker.regional.it);

        /* jQueryUI datetimepicker addon */
        $.timepicker.regional.it = {
            currentText: 'Ora',
            closeText: 'Fatto',
            ampm: false,
            amNames: ['AM', 'A'],
            pmNames: ['PM', 'P'],
            timeFormat: 'HH:mm',
            dateFormat: 'yy-mm-dd',
            timeSuffix: '',
            timeOnlyTitle: 'Scegli un orario',
            timeText: 'Orario',
            hourText: 'Ore',
            minuteText: 'Minuti',
            secondText: 'Secondi',
            millisecText: 'Millisecondi',
            timezoneText: 'Time Zone',
            stepMinute: 5,
            // dispositivi touch
            addSliderAccess: true,
            sliderAccessArgs: { touchonly: false }
        };
        $.timepicker.setDefaults($.timepicker.regional.it);

        var
            opts = {
                changeMonth: true,
                changeYear: true,
                showOtherMonths: true,
                selectOtherMonths: true
            },
            body = $('body'),
            plugins = {
                "datepicker": "input.input_date",
                "timepicker": "input.input_time",
                "datetimepicker": "input.input_datetime"
            },
            attachPicker = function (el, plugin) {
                var $el = $(el),
                    o = $el.data('options') || {};

                o = $.extend({}, opts, o);

                $el[plugin](o);
            };

        $.each(plugins, function (plugin, selector) {
            $(selector).each(function () {
                attachPicker($(this), plugin);
            });

            body.on('focus', selector, function () {
                var $el = $(this);
                if (!$el.hasClass('hasDatepicker')) {
                    attachPicker($el, plugin);
                }
            });
        });
    }());

    /**
     * Richiesta Ajax per l'indicizzazione della ricerca
     *
     * TO-DO: div modale con indicatore di "occupato"
     */
    $('#index-action').on('click', function (event) {
        var url = $(this).attr('href');

        $.post(url, {}, function (d) {
            alert(d.message);
        });

        event.preventDefault();
    });

    /**
     * Serve per la gestione della conferma di uscita senza salvataggio dei dati tipo wordpress (chiede se si vuole lasciare la pagina senza salvare)
     */
    $('form.checksave').submit(function () {
        form_changed = false;

        return true;
    }).find('input, textarea, select').on('change', function () {
        form_changed = true;
    });


    /**
     * Abilitazione/disabilitazione dei pannelli delle traduzioni nei nodi
     */
    function checkChecked(lckb) {
        if (lckb.length < 2) {
            // Disabilito la checkbox che resta (che sicuramente non è quella che ho cliccato)
            lckb.attr('disabled', 'disabled');
        } else {
            lckb.each(function () {
                $(this).removeAttr('disabled');
            });
        }
    }

    /**
     * Attivazione di una determinata tab
     */
    function setActiveTab(a, ref) {
        var href = a.attr('href'),
            input_name;

        if (href.indexOf('#', 0) !== -1) {
            // Se trovo il simbolo di cancelletto (#) nel tag href
            href = href.substr(1);
        }

        if (ref) {
            $('input.tab-handler[name="' + ref + '"]').val(href);
        }
    }

    $('.languages-multiple').each(function () {
        var languages = $(this),
            tabs = $('.tabs.translations'),
            panels = $(".tabsPanel"),
            ckbs = languages.find('input[type="checkbox"]');

        ckbs.each(function () {
            var ckb = $(this),
                hid = ckb.parent().find('input[type="hidden"]');

            if (ckb.is(':checked')) {
                hid.val('on');
            } else {
                hid.val('off');
            }
        });

        ckbs.on('click', function (e) {
            var ckb = $(this),
                hid = ckb.parent().find('input[type="hidden"]'),
                tab = tabs.find('li#tab_' + ckb.val()),
                ntab,
                a,

                // Se è l'ultima checkbox non posso disattivarla (disabled)
                lckb = languages.find('input[type="checkbox"]:checked');

            checkChecked(lckb);

            if (ckb.is(':checked')) {
                tab.show();
                hid.val('on');
            } else {
                if (tab.hasClass('active')) {
                    // Se sono nella tab attiva devo spostarmi di tab e nasconderla
                    tab.removeClass('active');
                    panels.find(tab.find('a').attr('href')).hide();


                    // Attivo la tab della prima checkbox attiva che trovo
                    ntab = tabs.find('li#tab_' + $(lckb[0]).val());
                    a = ntab.find('a');
                    ntab.addClass('active');
                    panels.find(a.attr('href')).show();
                    setActiveTab(a, tabs.data('ref'));
                }

                tab.hide();
                hid.val('off');
            }
        });

        // In creazione di un nuovo nodo potrei non avere le tab attive
        checkChecked(languages.find('input[type="checkbox"]:checked'));
    });

    $('.tabs').on('click', 'li a', function (event) {
        setActiveTab($(this), $(event.delegateTarget).data('ref'));
    });

    /**
     * Selettore della lingua nelle liste dei nodi
     */
    $('select.languages_select').each(function () {
        var select = $(this), form = select.closest('form');

        select.on('change', function () {
            form.submit();
        });
    });

    /**
     * Selettore del tipo di collegamento
     * visualizzo i campi corretti in base al valore della select del tipo di collegamento
     */
    //(function () {
    //    var onLinkTypeSelectChange = function () {
    //        var sel = $(this),
    //            types = sel.closest('dd,td').find('div.link-type'),
    //            curKey = sel.find('option:selected').data('value'),
    //            curType = types.filter('div.link-type-' + curKey),
    //            span = curType.find('span'),
    //            row = sel.closest('li'),
    //            name;
    //
    //        types.hide().find('span').html('');
    //
    //        if (span.length) {
    //            name = span.data("name");
    //
    //            // Potrei essere all'interno di un repeater
    //            if (row.length) {
    //                name = name.replace('[new]', '[' + row.data('id') + ']');
    //            }
    //
    //            span.html(function () {
    //                return '<select name="' + name + '">' + Pongho.linkField[span.data('language')][curKey] + '</select>';
    //            });
    //
    //            span.find('select').val(span.data('value'));
    //        }
    //
    //        curType.show();
    //    };
    //
    //    $('body').on('change', 'select.link-type-select', onLinkTypeSelectChange);
    //
    //    $('select.link-type-select').each(onLinkTypeSelectChange);
    //}());
});

/**
 * Serve per la gestione della conferma di uscita senza salvataggio dei dati tipo wordpress (chiede se si vuole lasciare la pagina senza salvare)
 */
window.onbeforeunload = function (e) {
    "use strict";

    if (form_changed) {
        e = e || window.event;

        var msg = "Sure you want to leave?";

        // For IE and Firefox prior to version 4
        if (e) {
            e.returnValue = msg;
        }

        // For Safari
        return msg;
    }
};
