<?php
/**
 * @var \Application\Core\I18n\Translator\Translator $translator
 * @var \Application\Admin\Widget\WidgetsCollection  $widgets
 * @var \Application\Admin\Widget\Widget             $widget
 */
?><div class="section">

	<h2><?php echo $translator->trans('Dashboard'); ?></h2>

	<?php if (isset($search_engines_disabled)): ?>
		<div class="box error"><span><?php echo $search_engines_disabled; ?></span></div>
	<?php endif; ?>

	<?php if (isset($google_analytics_disabled)): ?>
		<div class="box error"><span><?php echo $google_analytics_disabled; ?></span></div>
	<?php endif; ?>

	<div id="dashboard-widgets">
		<?php foreach ($widgets as $widget): ?>
			<div class="dashboard-widget-column-<?php echo $widget->getColumns(); ?>">
				<div class="dashboard-widget" id="dashboard-widget-<?php echo $widget->getKey(); ?>">
					<h3><?php echo $widget->getName(); ?></h3>
					<div class="dashboard-widget-content"><?php echo $widget->render(); ?></div>
				</div>
			</div>
		<?php endforeach; ?>
	</div>

</div><!-- .section -->
