<?php
/**
 * @var \Application\Core\Localization $lang
 * @var \Pongho\Form\Field\TextField $field
 * @var string $autocomplete_url
 * @var string $selected
 */
?>
<div class="control-group autosuggest-field">
    <label for="<?php echo $field->getId(); ?>-search" class="control-label"><?php echo $field->getLabel(), $field->isRequired() ? '<i>*</i>' : ''; ?></label>
    <div class="controls">
        <?php echo $field->getHiddenField(); ?>
        <p id="<?php echo $field->getId(); ?>-label"><?php echo $selected; ?></p>
        <input type="text" id="<?php echo $field->getId(); ?>-search" class="input_text autosuggest"
               placeholder="<?php echo $field->getAttribute('placeholder', $lang->get('search')); ?>"
               data-url="<?php echo $autocomplete_url; ?>"
               data-label="#<?php echo $field->getId(); ?>-label"
               data-master="#<?php echo $field->getId(); ?>">
        <?php if ($description = $field->getDescription()): ?>
            <small><?php echo $description; ?></small>
        <?php endif; ?>
    </div>
</div>
