/**
 * Gruntfile.js
 *
 * @author Daniele De Nobili
 */

/*global module */

module.exports = function (grunt) {
    "use strict";

    grunt.initConfig({
        sass: {
            dist: {
                options: {
                    style: 'compressed'
                },
                files: {
                    'adminbar.css': 'adminbar.scss',
                    'db-profiler/style.css': 'db-profiler/style.scss'
                }
            }
        },
        imageEmbed: {
            dist: {
                src: [ 'adminbar.css' ],
                dest: 'adminbar.css',
                options: {
                    deleteAfterEncoding : false
                }
            }
        },
        uglify: {
            build: {
                src: 'db-profiler/script.js',
                dest: 'db-profiler/script.min.js'
            }
        }
    });

    grunt.loadNpmTasks('grunt-contrib-sass');
    grunt.loadNpmTasks("grunt-image-embed");
    grunt.loadNpmTasks('grunt-contrib-uglify');

    grunt.registerTask('default', ['sass', 'imageEmbed', 'uglify']);
};
