<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author  Daniele Termini
 * @package Application\Admin
 */

namespace Application\Admin\Model;

use ActiveRecord\Base;

/**
 * Class Filter
 *
 * @property int                        $id
 * @property string                     $namespace
 * @property string                     $filter
 * @property \Pongho\Utilities\DateTime $created_at
 * @property \Pongho\Utilities\DateTime $updated_at
 * @property int                        $user_id
 */
class Filter extends Base
{
	public static $table_name = 'filters';

    /**
     * Restituisce i filtri deserializzati
     *
     * @return array
     */
    public function getFilters()
    {
        $filters = array();

        if ($this->filter) {
            /** @var $row \Pongho\Form\Repeater\RepeaterRow */
            foreach (unserialize($this->filter) as $filter) {
                // Evito i filtri malformati (es possibili vecchie versioni)
                if (!isset($filter['field']) || !isset($filter['operator']) || !isset($filter['valuefield']) || !isset($filter[$filter['valuefield']])) {
                    continue;
                }

                // Gestione casi particolari
                switch ($filter['operator']) {
                    case 'DATEBETWEEN':
                        $filters[$filter['field']][$filter['operator']] = array($filter[$filter['valuefield']], $filter[$filter['valuefield'] . '_to']);
                        break;

                    default:
                        $filters[$filter['field']][$filter['operator']] = $filter[$filter['valuefield']];
                        break;
                }
            }

            return $filters;
        }

        return array();
    }
}
