<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin;

use Application\Admin\DependencyInjection\AdminBarServiceProvider;
use Application\Admin\DependencyInjection\AdminServicesProvider;
use Application\Admin\DependencyInjection\AdminSidebarServiceProvider;
use Application\Admin\DependencyInjection\DashboardWidgetsServiceProvider;
use Application\Admin\DependencyInjection\RoutingServiceProvider;
use Application\Admin\DependencyInjection\TranslationServiceProvider;
use Application\Admin\DependencyInjection\WidgetsServiceProvider;
use Pongho\Core\Plugin;
use Pongho\Core\TemplateResponse;
use Pongho\Http\Response;
use Pongho\EventDispatcher\Event;

/**
 * Kernel.
 */
class Kernel extends Plugin
{
    const VERSION = '1.0.0-dev';

	/**
	 * @access protected
	 * @var \Application\Admin\AdminBar\AdminBar
	 */
	protected $admin_bar;

    /**
     * @access protected
     * @var \Application\Admin\Widget\WidgetsCollection
     */
    protected $admin_widgets;

    /**
	 * {@inheritdoc}
	 */
	public function setUp()
	{
		return true;
	}

	/**
     * {@inheritdoc}
	 */
	public function load()
	{
        // Dependency Injection
        $this->container->register(new AdminSidebarServiceProvider());
        $this->container->register(new AdminServicesProvider());
        $this->container->register(new RoutingServiceProvider());
        $this->container->register(new AdminBarServiceProvider());
		$this->container->register(new WidgetsServiceProvider());
        $this->container->register(new DashboardWidgetsServiceProvider());
        $this->container->register(new TranslationServiceProvider());

		$this->connect('core.filter_response', 'addAdminBar');
	}

	/**
     * {@inheritdoc}
	 */
	public function install()
	{
	}

	/**
     * {@inheritdoc}
	 */
	public function uninstall()
	{
	}

	/**
     * {@inheritdoc}
	 */
	public function enable()
	{
	}

	/**
     * {@inheritdoc}
	 */
	public function disable()
	{
	}

    /**
     * Risponde al filtro `core.filter_response` per aggiungere la barra di amministrazione alla risposta.
     *
     * @param \Pongho\EventDispatcher\Event $event
     * @param \Pongho\Http\Response         $response
     * @return \Pongho\Http\Response
     */
    public function addAdminBar(Event $event, Response $response)
    {
        /** @var \Pongho\Http\Request $request */
        $request = $this->container->getService('request');

        if ($request->query->get('modal') || $request->isAjax()) {
            return $response;
        }

        if ($response instanceof TemplateResponse && $this->container->getService('current_user')->hasPermit('admin')) {
            /** @var \Application\Admin\AdminBar\AdminBarRenderer $builder */
            $renderer = $this->container->getService('admin_bar_renderer');

            return $renderer->render($response);
        }

        return $response;
    }
}
