<?php

namespace Application\Admin\Form\LinkField;

use Application\Cms\Model\Taxonomy;
use Application\Cms\Model\Term;
use Application\Core\Model\LanguageModule;
use Application\Core\Model\LanguageSite;
use Application\Core\Model\LinkType;
use Pongho\Core\Kernel;

/**
 * Class TermHandler
 *
 * @deprecated
 */
class TermHandler extends BaseHandler
{
    private $taxonomies = array();
    private $terms = array();

    /**
     * {@inheritdoc}
     */
    public function getClass($type = '')
    {
        return get_class($this) . '::' . $type;
    }

    /**
     * {@inheritdoc}
     */
    public function addTypesOptions($language_id, array $options)
    {
        foreach ($this->getTaxonomies($language_id) as $taxonomy) {
            $key = 'term-' . $taxonomy->node_type . '-' . $taxonomy->name;
            $options[$this->getClass($key)] = 'term-' . $taxonomy->name;
        }

        return $options;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $language_id, LinkType $link_type = null)
    {
        $blocks = array();
        $html = Kernel::instance()->getContainer()->getService('template_html');

        foreach ($this->getTaxonomies($language_id) as $taxonomy) {
            $key = 'term-' . $taxonomy->node_type . '-' . $taxonomy->name;
            $blocks[$key] = '<select name="' . $name . '[' . $key . ']">' . $html->selectHierarchy(
                    $this->getTerms($taxonomy, $language_id),
                    ($link_type === null ? null : $link_type->model_id)
                ) . '</select>';
        }

        return $blocks;
    }

    /**
     * {@inheritdoc}
     */
    public function renderSpan($name, $language_id, LinkType $link_type = null)
    {
        $blocks = array();

        foreach ($this->getTaxonomies($language_id) as $taxonomy) {
            $key = 'term-' . $taxonomy->node_type . '-' . $taxonomy->name;
            $blocks[$key] = '<span data-name="' . $name . '[' . $key . ']" data-value="' . ($link_type === null ? '' : $link_type->model_id) . '" data-language="' . $language_id . '"></span>';
        }

        return $blocks;
    }

    /**
     * {@inheritdoc}
     */
    public function getSelectOptions($language_id, array $query_options = array())
    {
        $options = array();
        $html = Kernel::instance()->getContainer()->getService('template_html');

        foreach ($this->getTaxonomies($language_id) as $taxonomy) {
            $options['term-' . $taxonomy->node_type . '-' . $taxonomy->name] = $html->selectHierarchy($this->getTerms($taxonomy, $language_id));
        }

        return $options;
    }

    /**
     * Ricava le tassonomie del sito
     *
     * @param $language_id
     * @return mixed
     */
    private function getTaxonomies($language_id)
    {
        if (!array_key_exists($language_id, $this->taxonomies)) {
            $this->taxonomies[$language_id] = Taxonomy::findAllBySiteAndlanguage($this->site_id, $language_id);
        }

        return $this->taxonomies[$language_id];
    }

    /**
     * Ricava i termini della tassonomia
     *
     * @param Taxonomy $taxonomy
     * @param          $language_id
     * @return mixed
     */
    private function getTerms(Taxonomy $taxonomy, $language_id)
    {
        $tax_key = $taxonomy->node_type . '-' . $taxonomy->name;
        if (!isset($this->terms[$tax_key][$language_id])) {
            $terms = array();
            foreach ($taxonomy->getTerms($language_id) as $term) {
                $terms[$term->parent_id][$term->id] = $term->title;
            }

            $this->terms[$tax_key][$language_id] = $terms;
        }

        return $this->terms[$tax_key][$language_id];
    }

    /**
     * {@inheritdoc}
     */
    public static function parseAttributes(array $attributes)
    {
        $key = $attributes['link_type'];

        if (array_key_exists($key, $attributes)) {
            $attributes['model_id'] = $attributes[$key];

            $term = Term::find($attributes['model_id'], $attributes['language_id']);

            $attributes['model_path'] = $term->permalink;
        }

        return $attributes;
    }

    /**
     * {@inheritdoc}
     */
    public static function getResource(LinkType $link_type)
    {
        $term = get_term($link_type->model_id);

        return $term;
    }

    /**
     * {@inheritdoc}
     */
    public static function getTitle(LinkType $link_type)
    {
        $term = static::getResource($link_type);

        if ($term) {
            return $term->title();
        }

        return parent::getTitle($link_type);
    }
}
