<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Admin\Form\LinkField;

use Application\Cms\Model\Menu;
use Application\Core\Model\LinkType;
use Pongho\Core\Kernel;

/**
 * Class MenuHandler
 *
 * @deprecated
 */
class MenuHandler extends BaseHandler
{
    /**
     * {@inheritdoc}
     */
    public function getClass($type = '')
    {
        return get_class($this) . '::menu';
    }

    /**
     * {@inheritdoc}
     */
    public function addTypesOptions($language_id, array $options)
    {
        $options[$this->getClass()] = 'menu';

        return $options;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $language_id, LinkType $link_type = null)
    {
        $html = Kernel::instance()->getContainer()->getService('template_html');
        $menu_id = $link_type === null ? null : $link_type->model_id;

        return array(
            'menu' => '<select name="' . $name . '">' . $html->select($this->getMenus($menu_id), $menu_id) . '</select>',
        );
    }

    /**
     * {@inheritdoc}
     */
    public function renderSpan($name, $language_id, LinkType $link_type = null)
    {
        return array(
            'menu' => '<span data-name="' . $name . '[menu_id]" data-value="' . ($link_type === null ? '' : $link_type->model_id) . '" data-language="' . $language_id . '"></span>',
        );
    }

    /**
     * {@inheritdoc}
     */
    public function getSelectOptions($language_id, array $query_options = array())
    {
        $html = Kernel::instance()->getContainer()->getService('template_html');

        return array('menu' => $html->select($this->getMenus($query_options)));
    }

    /**
     * @param array $query_options
     * @internal param int $menu_id
     * @return array
     */
    protected function getMenus(array $query_options = array())
    {
        /** @var \Application\Core\Model\Site $site */
        $site = Kernel::instance()->getContainer()->getService('site');

        $options = Menu::addCondition($query_options, array('site_id = :site', 'site' => $site->id));

        $menus = array();

        /** @var \Application\Cms\Model\Menu $menu */
        foreach (Menu::all($options) as $menu) {
            $menus[$menu->id] = $menu->title;
        }

        return $menus;
    }

    /**
     * {@inheritdoc}
     */
    public static function parseAttributes(array $attributes)
    {
        if (array_key_exists('menu_id', $attributes)) {
            $attributes['model_id'] = $attributes['menu_id'];
        }

        return $attributes;
    }

    /**
     * {@inheritdoc}
     */
    public static function getResource(LinkType $link_type)
    {
        return get_menu($link_type->model_id);
    }

    /**
     * {@inheritdoc}
     */
    public static function getTitle(LinkType $link_type)
    {
        /** @var \Application\Cms\Model\Menu $menu */
        if ($menu = Menu::find($link_type->model_id)) {
            return $menu->name;
        }

        return '';
    }
}
