<?php

namespace Application\Admin\Form\LinkField;

use Application\Core\Model\LinkType;

/**
 * Class LinkHandler
 *
 * @deprecated
 */
class LinkHandler extends BaseHandler
{
    /**
     * {@inheritdoc}
     */
    public function getClass($type = '')
    {
        return get_class($this) . '::link';
    }

    /**
     * {@inheritdoc}
     */
    public function addTypesOptions($language_id, array $options)
    {
        $options[$this->getClass()] = 'link';

        return $options;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $language_id, LinkType $link_type = null)
    {
        if ($link_type === null) {
            return array('link' => '<input type="text" name="' . $name . '[model_path]" class="input_text">');
        }

        return array('link' => '<input type="text" name="' . $name . '[model_path]" value="' . $link_type->model_path . '" class="input_text">');
    }

    /**
     * {@inheritdoc}
     */
    public function renderSpan($name, $language_id, LinkType $link_type = null)
    {
        return $this->render($name, $language_id, $link_type);
    }

    /**
     * {@inheritdoc}
     */
    public function getSelectOptions($language_id, array $query_options = array())
    {
        return array();
    }

    /**
     * {@inheritdoc}
     */
    public static function parseAttributes(array $attributes)
    {
        // Commentato in data 16/12/2013: un link diretto può contenere caratteri maiuscoli
        //$attributes['model_path'] = strtolower($attributes['model_path']);

        if (!preg_match('#^((f|ht)tp(s)?\:\/\/|mailto\:|callto\:|\#)#', $attributes['model_path'])) {
            $attributes['model_path'] = '/' . ltrim($attributes['model_path'], '/');
        }

        // Normalizzo un'eventuale query string
        $url_pieces = explode('?', $attributes['model_path']);

        $query = '';

        if (isset($url_pieces[1])) {
            $parts = array();
            $order = array();

            foreach (explode('&', $url_pieces[1]) as $segment) {
                if (strpos($segment, '=')) {
                    $tmp = explode('=', rawurldecode($segment), 2);
                    $parts[] = rawurlencode($tmp[0]) . '=' . rawurlencode($tmp[1]);
                    $order[] = $tmp[0];
                } else {
                    $parts[] = $segment;
                    $order[] = $segment;
                }
            }

            array_multisort($order, SORT_ASC, $parts);

            $query = implode('&', $parts);
        }

        $url = htmlspecialchars(trim($url_pieces[0] . ($query ? '?' . $query : '')));

        $attributes['model_path'] = $url;

        return $attributes;
    }

    /**
     * {@inheritdoc}
     */
    public static function getTitle(LinkType $link_type)
    {
        return static::getPermalink($link_type);
    }
}
