<?php

namespace Application\Admin\Form\LinkField;

use Application\Core\Model\LinkType;

/**
 * Class BaseHandler
 *
 * @deprecated
 */
abstract class BaseHandler
{
    /**
     * Costruttore
     *
     * @access public
     * @param integer $site_id
     * @param string  $field Nome del campo/colonna database
     */
    public function __construct($site_id, $field)
    {
        $this->site_id = (int)$site_id;
        $this->field = $field;
    }

    /**
     * Restituisce la classe dell'handler
     *
     * @param string $type
     * @return string
     */
    abstract public function getClass($type = '');

    /**
     * Aggiunge le opzioni della seconda select (quella che appare dopo aver selezionato un determinato tipo di LinkType)
     *
     * @abstract
     * @access public
     * @param integer $language_id
     * @param array   $options
     */
    abstract public function addTypesOptions($language_id, array $options);

    /**
     * Restituisce l'array con i blocchi del codice HTML del campo (select)
     *
     * @abstract
     * @access public
     * @param string                           $name
     * @param integer                          $language_id
     * @param \Application\Core\Model\LinkType $link_type default null
     * @return array
     */
    abstract public function render($name, $language_id, LinkType $link_type = null);

    /**
     * Restituisce l'array con i blocchi del codice HTML del campo (span)
     *
     * @abstract
     * @access public
     * @param string                           $name
     * @param integer                          $language_id
     * @param \Application\Core\Model\LinkType $link_type
     * @return array
     */
    abstract public function renderSpan($name, $language_id, LinkType $link_type = null);

    /**
     * Restituisce le opzioni della select dell'handler
     *
     * @param       $language_id
     * @param array $query_options
     * @return string[]
     */
    abstract public function getSelectOptions($language_id, array $query_options = array());

    public static function getPermalink(LinkType $link_type)
    {
        return url($link_type->model_path);
    }

    /**
     * @param $link_type
     * @return mixed
     */
    public static function getResource(LinkType $link_type)
    {
        return null;
    }

    public static function getTitle(LinkType $link_type)
    {
        return '';
    }

    /**
     * Gestisce il salvataggio e l'aggiornamento del modello LinkType
     *
     * @access public
     * @static
     * @param array                            $attributes
     * @param \Application\Core\Model\LinkType default = null
     * @return integer L'id del LinkType creato o aggiornato
     */
    public static function save($attributes, LinkType $link_type = null)
    {
        if ($link_type === null) {
            $link_type = LinkType::create($attributes);
        } else {
            $link_type->update_attributes($attributes);
            $link_type->save();
        }

        return $link_type ? $link_type->id : null;
    }

    /**
     * Svuota la cache del modello
     *
     * @access public
     * @static
     * @param  \Application\Core\Model\LinkType
     * @return boolean
     */
    public static function updateCache(LinkType $link_type)
    {
        return true;
    }

    /**
     * Controlla ed aggiunge gli attributi mancanti
     *
     * @static
     * @param array $attributes
     * @return array
     */
    public static function parseAttributes(array $attributes)
    {
        return $attributes;
    }
}
