<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form;

use Pongho\Form\Subject\RowSubjectInterface;
use Pongho\Utilities\DateTime;

/**
 * Subject array
 */
class FilterRowSubject implements RowSubjectInterface
{
    protected $row = array();

    /**
     * @param array $row
     */
    public function __construct(array $row)
    {
        $this->row = $row;
    }

    /**
     * {@inheritdoc}
     */
    public function getModel()
    {
        return $this->row;
    }

    /**
     * {@inheritdoc}
     */
    public function get($property)
    {
        if (!isset($this->row[$property])) {
            return null;
        }

        if (is_array($this->row[$property])) {
            return $this->row[$property];
        }

        return $this->row[$property];
    }

    /**
     * {@inheritdoc}
     */
    function set($property, $value)
    {
        if (is_array($value)) {
            $this->row[$property] = $value;
        }

        $this->row[$property] = $value;
    }

    /**
     * {@inheritdoc}
     */
    function save()
    {
        // Trattamento delle date
        $this->row['value_date'] = $this->row['value_date'] instanceof DateTime ? $this->row['value_date']->format('Y-m-d') : $this->row['value_date'];

        return true;
    }

    /**
     * {@inheritdoc}
     */
    function transaction($callback, array $request)
    {
        return $this->save();
    }

    /**
     * {@inheritdoc}
     */
    function getErrors()
    {
        return array();
    }

    /**
     * {@inheritdoc}
     */
    public function delete()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function getProperties()
    {
        return $this->row;
    }
}
