<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form\Field;

use Pongho\Form\Field\TextField;

/**
 * PriceField.
 */
class PriceField extends TextField
{
    /**
     * {@inheritdoc}
     */
    public function getValue()
    {
        return format_price(parent::getValue(), false);
    }

    /**
     * {@inheritdoc}
     */
    public function setValue($value)
    {
        return parent::setValue(parse_price($value));
    }
}
