<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Admin
 */

namespace Application\Admin\Form;

use ActiveRecord\Base as Model;

/**
 * Base per i campi.
 *
 * @deprecated
 */
abstract class Field
{
	/**
	 * Istanza del modello.
	 *
	 * @access protected
	 * @var object Model
	 */
	protected $model;

	/**
	 * Nome dell’attributo del modello.
	 *
	 * @access protected
	 * @var string
	 */
	protected $attribute_name;

	/**
	 * Opzioni.
	 *
	 * @access protected
	 * @var array
	 */
	protected $options = array();

	/**
	 * Valore di default del campo.
	 *
	 * @access protected
	 * @var mixed
	 */
	protected $default;

	/**
	 * Costruttore.
	 *
	 * @access public
	 * @param \ActiveRecord\Base $model Istanza del modello.
	 * @param string $attribute_name Nome del campo.
	 * @param array $options Opzioni per il campo.
	 * @return void
	 */
	public function __construct(Model $model, $attribute_name, array $options)
	{
		$this->model = $model;
		$this->attribute_name = $this->post_name = $attribute_name;
		$this->options = $options;

		$this->parseOptions();
	}

	/**
	 * Controlla la presenza delle opzioni essenziali.
	 *
	 * @access protected
	 * @return void
	 */
	protected function parseOptions()
	{
		if ( array_key_exists('post', $this->options) )
		{
			$this->post_name = $this->options['post'];
		}

		if ( array_key_exists('default', $this->options) )
		{
			$this->default = $this->options['default'];
		}
	}

	/**
	 * Restituisce se una opzione è impostata.
	 *
	 * @access protected
	 * @param string $name
	 * @return boolean
	 */
	protected function has($name)
	{
		return array_key_exists($name, $this->options);
	}

	/**
	 * Restituisce il valore di una opzione.
	 *
	 * @access protected
	 * @param string $name
	 * @param mixed $default
	 * @param boolean $thrown_exception
	 * @return mixed
	 * @throws \InvalidArgumentException Se $thrown_exception è impostato a `true` e l'opzione non è definita.
	 */
	protected function get($name, $default = null, $thrown_exception = false)
	{
		if ( array_key_exists($name, $this->options) )
		{
			return $this->options[$name];
		}

		if ( $thrown_exception )
		{
			throw new \InvalidArgumentException(sprintf('Option "%s" not exists!', $name));
		}

		return $default;
	}

	protected function getBaseAttributes()
	{
		return $this->get('attributes', array());
	}

	/**
	 * Imposta il valore dell’attributo del modello in base ai dati arrivati in POST.
	 *
	 * @access public
	 * @return void
	 */
	abstract public function setAttributeModel();

	/**
	 * Restituisce il codice HTML per la generazione del campo (input, select, textarea).
	 *
	 * @access public
	 * @return string
	 */
	 abstract public function getViewCode();
}
