<?php
/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form\Exception;

use Pongho\Form\Exception\FieldException;

/**
 * Class TranslationFieldException
 */
class TranslationFieldException extends FieldException
{
    protected $field;
    protected $language_id;

    /**
     * {@inheritdoc}
     * @param string $message
     * @param        $field
     * @param        $language_id
     */
    public function __construct($message, $field, $language_id)
    {
        $this->field = $field;
        $this->language_id = $language_id;

        parent::__construct($message);
    }

    /**
     * @return mixed
     */
    public function getField()
    {
        return $this->field;
    }

    /**
     * @return integer
     */
    public function getLanguageId()
    {
        return $this->language_id;
    }
}
