<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\Widgets\Stats\View\GoogleChart\ChartFactory;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * WidgetsServiceProvider
 */
class WidgetsServiceProvider implements ServiceProviderInterface
{
    /**
     * @var array
     */
    protected static $sharedServices = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('widget_google_chart_factory', array($this, 'getGoogleChartFactory'));
    }

    /**
     * @param Container $container
     * @return ChartFactory
     */
    public function getGoogleChartFactory(Container $container)
    {
        if (!array_key_exists('google_chart_factory', static::$sharedServices)) {
            static::$sharedServices['google_chart_factory'] = new ChartFactory($container->getService('template_head'));
        }

        return static::$sharedServices['google_chart_factory'];
    }
}
