<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Core\I18n\Translator\Translator;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class TranslationServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->extend(
            'translator',
            function(Translator $translator, Container $container) {
                $translator->addApplicationTranslations('Admin', $container->getService('current_user')->language->culture);
            }
        );
    }
}
